/***********************************************************************
 * Copyright (c) 2009 CA, Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     CA, Inc. - Initial implementation
 *     SAS Institute - Bug 275669 
 ***********************************************************************/
package org.eclipse.cosmos.me.sdd.o10r.impl;

import org.eclipse.cosmos.me.sdd.advisor.IAdvisor;
import org.eclipse.cosmos.me.sdd.cr.ResourceHandler;
import org.eclipse.cosmos.me.sdd.o10r.Orchestrator;
import org.eclipse.cosmos.me.sdd.op.OperationHandler;
import org.eclipse.cosmos.me.sdd.schema.AdditionalContentType;
import org.eclipse.cosmos.me.sdd.schema.ArtifactType;
import org.eclipse.cosmos.me.sdd.schema.BooleanParameterType;
import org.eclipse.cosmos.me.sdd.schema.DeploymentDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.InstallableUnitType;
import org.eclipse.cosmos.me.sdd.schema.InstallationArtifactsType;
import org.eclipse.cosmos.me.sdd.schema.IntegerParameterType;
import org.eclipse.cosmos.me.sdd.schema.OperationType;
import org.eclipse.cosmos.me.sdd.schema.PackageDescriptorType;
import org.eclipse.cosmos.me.sdd.schema.StringParameterType;
import org.eclipse.cosmos.me.sdd.schema.URIParameterType;
import org.eclipse.cosmos.me.sdd.schema.ext.SDDContext;
import org.eclipse.cosmos.me.sdd.schema.marshal.Marshaller;

public class OrchestratorImpl implements Orchestrator {
	private Marshaller marshaller;
	private OperationHandler ophandler;
	private ResourceHandler rsrcHandler;
	private IAdvisor advisor;
	
	public void setMarshaller(Marshaller marshaller) {
		this.marshaller = marshaller;
	}
	
	public void unsetMarshaller(Marshaller marshaller) {
		this.marshaller = null;
	}
	
	public void setOperationHandler(OperationHandler ophandler) {
		this.ophandler = ophandler;
	}
	
	public void unsetOperationHandler(OperationHandler ophandler) {
		this.ophandler = null;
	}
	
	public void setResourceHandler(ResourceHandler rsrcHandler) {
		this.rsrcHandler = rsrcHandler;
	}
	
	public void unsetResourceHandler(ResourceHandler rsrcHandler) {
		this.rsrcHandler = null;
	}
	
	public void setAdvisor(IAdvisor advisor) {
		this.advisor = advisor;
	}
	
	public void unsetAdvisor(IAdvisor advisor) {
		this.advisor = null;
	}
	
	public void deploy(String packageUri, String operation) {
		OperationType op = OperationType.fromValue(operation);
		switch (op) {
		case INSTALL:
		case UNINSTALL:
			installableUnit(packageUri, op);
			break;
		default:
			break;
		}
	}

	private void installableUnit(String packageUri, OperationType op) {
		SDDContext ctxt = new SddContextImpl(marshaller, packageUri);
		PackageDescriptorType pd = ctxt.getPackageDescriptor();
		if (pd != null) {
			DeploymentDescriptorType dd = ctxt.getDeploymentDescriptor();
			if (dd != null) {
				
				if(installableUnitResolution(ctxt)) {
					InstallableUnitType unit = dd.getInstallableUnit();
					if (unit != null) {
						if (unit.getArtifacts() != null) {
							InstallationArtifactsType artifacts = unit.getArtifacts();
							switch (op) {
							case INSTALL:
								if (artifacts.getInstallArtifact() != null) {
									ArtifactType artifact = artifacts.getInstallArtifact();
									ophandler.invokeAction(ctxt, artifact, op);
									for (AdditionalContentType c : artifact.getAdditionalContent()) {
										ophandler.invokeAction(ctxt, artifact, c, op);
									}
								}
								break;
							case UNINSTALL:
								if (artifacts.getUninstallArtifact() != null) {
									ophandler.invokeAction(ctxt, artifacts.getUninstallArtifact(), op);
								}
								break;
							}
						}
					}
				}
			}
		}
	}

	private boolean installableUnitResolution(SDDContext ctxt) {
		new VariableResolver(ctxt, rsrcHandler).installableUnitResolver();
		RequirementsResolver reqResolver = new RequirementsResolver(ctxt, rsrcHandler);
		if(ctxt.getParameters().size() > 0) {
			if(advisor != null) {
				for(Object p : ctxt.getParameters().values()) {
					if(p instanceof URIParameterType) {
						ctxt.setVariable(((URIParameterType)p).getId(),
							advisor.requestParameter((URIParameterType)p).toString());
					}
					else if(p instanceof IntegerParameterType) {
						ctxt.setVariable(((IntegerParameterType)p).getId(),
							advisor.requestParameter((IntegerParameterType)p).toString());
					}
					else if(p instanceof StringParameterType) {	
						ctxt.setVariable(((StringParameterType)p).getId(),
							advisor.requestParameter((StringParameterType)p));
					}
					else if(p instanceof BooleanParameterType) {
						ctxt.setVariable(((BooleanParameterType)p).getId(),
							advisor.requestParameter((BooleanParameterType)p).toString());
					}
					
					if(!reqResolver.installableUnitResolver()) {
						advisor.displayError(reqResolver.getUnsatisifiedResource());
						return false;
					}
				}
			}
			else {
				if(!reqResolver.installableUnitResolver()) {
					advisor.displayError(reqResolver.getUnsatisifiedResource());
					return false;
				}
			}
		}
		
		return true;
	}
}

