/*******************************************************************************
 * Copyright (c) 2009 SAS Institute, Inc., and others
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute - initial API and implementation
 *     SAS Institute - Bug 275669
 ******************************************************************************/
package org.eclipse.cosmos.me.sdd.advisor;

import java.net.URI;

import org.eclipse.cosmos.me.sdd.schema.BooleanParameterType;
import org.eclipse.cosmos.me.sdd.schema.IntegerParameterType;
import org.eclipse.cosmos.me.sdd.schema.RequirementResourceConstraintType;
import org.eclipse.cosmos.me.sdd.schema.StringParameterType;
import org.eclipse.cosmos.me.sdd.schema.URIParameterType;

/**
 * Interface for handling parameter input requests.
 */
public interface IAdvisor {
	
	/**
	 * Request input for an Integer value as represented in a SDD.
	 * 
	 * @param ipt
	 * @return Integer value representing the input gathered.
	 */
 	public Integer requestParameter(IntegerParameterType ipt);
 	
	/**
	 * Request input for a String value as represented in a SDD.
	 * 
	 * @param spt
	 * @return String value representing the input gathered.
	 */
    public String requestParameter(StringParameterType spt);
    
	/**
	 * Request input for a Boolean value as represented in a SDD.
	 * 
	 * @param bpt
	 * @return Boolean value representing the input gathered.
	 */
    public Boolean requestParameter(BooleanParameterType bpt);
    
	/**
	 * Request input for an URI value as represented in a SDD.
	 * 
	 * @param upt
	 * @return URI value representing the input gathered.
	 */
    public URI requestParameter(URIParameterType upt);

	/**
	 * Display a message to the input.
	 * 
	 * @param message
	 * 		The string representing the value to be displayed.
	 */
    public void displayMessage(String message);
    
	/**
	 * Display an error to the input.
	 * 
	 * @param resource
	 * 		The string representing the value to be displayed.
	 */
    public void displayError(RequirementResourceConstraintType resource);
}
