/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.AllTests;
import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.BTGApplication;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.ValidationFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.XML_DAS;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.exception.XMLValidationException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.w3c.dom.Document;

public class BTG_Test
extends TestCase {
    private BTGApplication btgApp;
    private String fileNameBase;
    private String resultingResourceName;

    public BTG_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.fileNameBase = String.valueOf(System.getProperty("java.io.tmpdir")) + File.separator + "BTGTEST";
        this.btgApp = new BTGApplication();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public Document getSDDData(String file) throws FileNotFoundException, IOException, XMLValidationException {
        Document xmlDocument = null;
        FileInputStream inputStream = new FileInputStream(file);
        XML_DAS myXmlDas = ValidationFactory.DEFAULT_INSTANCE.createXML_DAS();
        try {
            try {
                xmlDocument = myXmlDas.loadDocument((InputStream)inputStream);
            }
            catch (Exception e) {
                e.printStackTrace();
                ((InputStream)inputStream).close();
            }
        }
        finally {
            ((InputStream)inputStream).close();
        }
        return xmlDocument;
    }

    public void testGetSupportedProperties() throws Exception {
        Collection<BTGProperty> btgp = this.btgApp.getSupportedProperties();
        BTG_Test.assertTrue((btgp != null ? 1 : 0) != 0);
        BTG_Test.assertEquals((int)btgp.size(), (int)1);
        BTG_Test.assertEquals((String)"OutputFileNameBase", (String)btgp.toArray(new BTGProperty[0])[0].getName());
        BTG_Test.assertTrue((boolean)btgp.toArray(new BTGProperty[0])[0].isRequired());
    }

    public void testWriteSDDs_ValidDDFile() throws FileNotFoundException, XMLValidationException, IOException {
        ArrayList<Document> sdds = new ArrayList<Document>();
        sdds.add(this.getSDDData(AllTests.VALID_DDFILE));
        this.btgApp.writeDescriptorsToFiles(sdds, this.fileNameBase);
        File output = new File(String.valueOf(this.fileNameBase) + ".dd.xml");
        try {
            new FileInputStream(output);
            output.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTG_Test.fail((String)"Did not create expected DD file.");
        }
    }

    public void testWriteSDDs_InvalidDDFile() throws XMLValidationException, FileNotFoundException, IOException {
        ArrayList<Document> sdds = new ArrayList<Document>();
        sdds.add(this.getSDDData(AllTests.INVALID_DDFILE));
        this.btgApp.writeDescriptorsToFiles(sdds, this.fileNameBase);
        File output = new File(String.valueOf(this.fileNameBase) + ".dd.xml");
        try {
            new FileInputStream(output);
            output.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTG_Test.fail((String)"Did not create expected DD file.");
        }
    }

    public void testWriteSDDs_ValidPDFile() throws FileNotFoundException, XMLValidationException, IOException {
        ArrayList<Document> sdds = new ArrayList<Document>();
        sdds.add(this.getSDDData(AllTests.VALID_PDFILE));
        this.btgApp.writeDescriptorsToFiles(sdds, this.fileNameBase);
        File output = new File(String.valueOf(this.fileNameBase) + ".pd.xml");
        try {
            new FileInputStream(output);
            output.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTG_Test.fail((String)"Did not create expected PD file.");
        }
    }

    public void testWriteSDDs_InvalidPDFile() throws XMLValidationException, FileNotFoundException, IOException {
        ArrayList<Document> sdds = new ArrayList<Document>();
        sdds.add(this.getSDDData(AllTests.INVALID_PDFILE));
        this.btgApp.writeDescriptorsToFiles(sdds, this.fileNameBase);
        File output = new File(String.valueOf(this.fileNameBase) + ".pd.xml");
        try {
            new FileInputStream(output);
            output.delete();
        }
        catch (FileNotFoundException fileNotFoundException) {
            BTG_Test.fail((String)"Did not create expected PD file.");
        }
    }

    public void testWriteSDDs_FileNotFound() throws IOException, XMLValidationException {
        try {
            ArrayList<Document> sdds = new ArrayList<Document>();
            sdds.add(this.getSDDData("aFile.xml"));
            this.btgApp.writeDescriptorsToFiles(sdds, this.fileNameBase);
            new File(String.valueOf(this.fileNameBase) + ".pd.xml");
            BTG_Test.fail((String)"Invalid file name, but no FileNotFoundException was thrown");
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public void testNullDescriptorList() throws FileNotFoundException, XMLValidationException, IOException {
        try {
            this.btgApp.writeDescriptorsToFiles(null, this.fileNameBase);
            BTG_Test.assertTrue((boolean)true);
        }
        catch (NullPointerException nullPointerException) {
            BTG_Test.fail((String)"Null descriptor list not handled.");
        }
    }

    public void testNullItemInDescriptorList() throws FileNotFoundException, XMLValidationException, IOException {
        ArrayList<Document> sdds = new ArrayList<Document>();
        sdds.add(this.getSDDData(AllTests.VALID_PDFILE));
        sdds.add(null);
        this.btgApp.writeDescriptorsToFiles(sdds, this.fileNameBase);
        new File(String.valueOf(this.fileNameBase) + ".pd.xml");
        try {
            this.btgApp.writeDescriptorsToFiles(sdds, this.fileNameBase);
            BTG_Test.assertTrue((boolean)true);
        }
        catch (NullPointerException nullPointerException) {
            BTG_Test.fail((String)"Null item in descriptor list not handled.");
        }
    }
}

