/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.cosmos.me.internal.deployment.sdd.resources.tooling.btg.Messages;
import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.BTGPlugin;
import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.util.PropertiesReader;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.SDD_DAS;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.ValidationFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.exception.XMLValidationException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.IBTGDataAggregator;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.IBTGDataCollector;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.SDDFragment;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.exception.InvalidCLInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.util.BTGLogUtil;
import org.eclipse.equinox.app.IApplication;
import org.eclipse.equinox.app.IApplicationContext;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTGApplication
implements IApplication {
    private static final String OUTPUT_FILEBASE_PROPERTY = "OutputFileNameBase";
    private static final String PD_NODENAME = "PackageDescriptor";
    private static final String DD_NODENAME = "DeploymentDescriptor";
    private String aggregatorChoice = null;
    private String propertiesFile = String.valueOf(System.getProperty("user.dir")) + File.separator + "BTG.ini";
    private boolean printToConsole = true;
    private static Logger logger = Logger.getLogger("org.eclipse.cosmos.me.deployment.sdd.tooling.btg");
    private static Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.deployment.sdd.tooling.btg.stdout");
    private Properties btgProperties = null;
    private Properties aggregatorProperties = null;
    private int aggregatorCount = 0;
    private IBTGDataAggregator aggregator = null;

    public void stop() {
    }

    public Object start(IApplicationContext arg0) throws Exception {
        String logFile = String.valueOf(System.getProperty("user.dir")) + File.separator + "logger.properties";
        BTGLogUtil.initialize(logFile);
        consoleLogger.info(Messages.getString("BTGApplication.5"));
        String[] params = new String[]{};
        if (arg0.getArguments().containsKey("application.args")) {
            params = (String[])arg0.getArguments().get("application.args");
        }
        Iterator<String> paramsIter = Arrays.asList(params).iterator();
        while (paramsIter.hasNext()) {
            String param = paramsIter.next();
            if (param.equalsIgnoreCase("-help") || param.equals("-?") || param.equalsIgnoreCase("-h")) {
                this.showHelp();
                return IApplication.EXIT_OK;
            }
            if (param.equalsIgnoreCase("-usage")) {
                this.showUsage();
                return IApplication.EXIT_OK;
            }
            if (param.equalsIgnoreCase("-propertiesFile")) {
                String nextParam = paramsIter.next();
                if (!nextParam.startsWith("-")) {
                    this.propertiesFile = nextParam;
                    continue;
                }
                InvalidCLInputException e = new InvalidCLInputException(Messages.getString("BTGApplication.14"));
                consoleLogger.severe("InvalidCLInputException");
                consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                logger.log(Level.SEVERE, "ExceptionStack", e);
                throw e;
            }
            if (param.equalsIgnoreCase("-printToConsole")) {
                this.printToConsole = true;
                continue;
            }
            InvalidCLInputException e = new InvalidCLInputException(String.valueOf(Messages.getString("BTGApplication.16")) + param);
            consoleLogger.severe("InvalidCLInputException");
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, "ExceptionStack", e);
            throw e;
        }
        Collection<IBTGDataCollector> dataCollectorInstances = BTGPlugin.getDataCollectorInstances();
        Collection<IBTGDataAggregator> dataAggregatorInstances = BTGPlugin.getDataAggregatorInstances();
        if (dataCollectorInstances == null || dataCollectorInstances.size() == 0) {
            consoleLogger.config(Messages.getString("BTGApplication.48"));
            return IApplication.EXIT_OK;
        }
        consoleLogger.config(Messages.getString("BTGApplication.46", Integer.toString(dataCollectorInstances.size())));
        if (dataAggregatorInstances == null || dataAggregatorInstances.size() == 0) {
            consoleLogger.config(Messages.getString("BTGApplication.49"));
            return IApplication.EXIT_OK;
        }
        consoleLogger.config(Messages.getString("BTGApplication.47", Integer.toString(dataAggregatorInstances.size())));
        PropertiesReader propsReader = new PropertiesReader(this.propertiesFile);
        Collection<Properties> props = propsReader.getPropertiesList();
        consoleLogger.config(Messages.getString("BTGApplication.17", this.propertiesFile));
        this.validatePluginProps(props, dataCollectorInstances, dataAggregatorInstances, propsReader);
        if (this.aggregatorCount == 0) {
            consoleLogger.config(Messages.getString("BTGApplication.50"));
            return IApplication.EXIT_OK;
        }
        if (this.aggregatorCount > 1) {
            consoleLogger.config(Messages.getString("BTGApplication.51"));
            return IApplication.EXIT_OK;
        }
        Collection<SDDFragment> sddFragments = this.findSDDFragments(props, dataCollectorInstances);
        Collection<Document> descriptorsList = this.findDescriptorsList(dataAggregatorInstances, sddFragments);
        if (descriptorsList == null || descriptorsList.isEmpty()) {
            consoleLogger.config(Messages.getString("BTGApplication.28"));
        } else if (descriptorsList.size() != 2) {
            consoleLogger.config(Messages.getString("BTGApplication.10", String.valueOf(descriptorsList.size())));
        } else {
            consoleLogger.info(Messages.getString("BTGApplication.27"));
            this.writeDescriptorsToFiles(descriptorsList, this.btgProperties.getProperty(OUTPUT_FILEBASE_PROPERTY));
        }
        consoleLogger.config(Messages.getString("BTGApplication.29"));
        return IApplication.EXIT_OK;
    }

    private void validatePluginProps(Collection<Properties> props, Collection<IBTGDataCollector> dataCollectorInstances, Collection<IBTGDataAggregator> dataAggregatorInstances, PropertiesReader propsReader) throws ParseException {
        for (Properties p : props) {
            String pluginID;
            if ("org.eclipse.cosmos.me.deployment.sdd.tooling.btg".equals(p.get("PluginID"))) {
                propsReader.checkSupportedProperties(p, this.getSupportedProperties());
                this.btgProperties = p;
                continue;
            }
            for (IBTGDataCollector dataCollectorInstance : dataCollectorInstances) {
                pluginID = BTGPlugin.getDataCollectorPluginID(dataCollectorInstance);
                if (!p.get("PluginID").equals(pluginID)) continue;
                propsReader.checkSupportedProperties(p, dataCollectorInstance.getSupportedProperties());
            }
            for (IBTGDataAggregator dataAggregatorInstance : dataAggregatorInstances) {
                pluginID = BTGPlugin.getDataAggregatorPluginID(dataAggregatorInstance);
                if (!p.get("PluginID").equals(pluginID)) continue;
                propsReader.checkSupportedProperties(p, dataAggregatorInstance.getSupportedProperties());
                ++this.aggregatorCount;
                this.aggregatorChoice = pluginID;
                this.aggregatorProperties = p;
            }
        }
    }

    private Collection<SDDFragment> findSDDFragments(Collection<Properties> props, Collection<IBTGDataCollector> dataCollectorInstances) throws Exception {
        ArrayList<SDDFragment> sddFragments = new ArrayList<SDDFragment>();
        for (Properties p : props) {
            for (IBTGDataCollector dataCollectorInstance : dataCollectorInstances) {
                Collection<SDDFragment> descriptorList;
                String pluginID = BTGPlugin.getDataCollectorPluginID(dataCollectorInstance);
                if (!p.get("PluginID").equals(pluginID) || (descriptorList = dataCollectorInstance.collectSDDData(p)) == null) continue;
                sddFragments.addAll(descriptorList);
            }
        }
        return sddFragments;
    }

    private Collection<Document> findDescriptorsList(Collection<IBTGDataAggregator> dataAggregatorInstances, Collection<SDDFragment> sddFragments) {
        Collection<Document> descriptorsList = null;
        for (IBTGDataAggregator dataAggregatorInstance : dataAggregatorInstances) {
            String pluginID = BTGPlugin.getDataAggregatorPluginID(dataAggregatorInstance);
            if (!this.aggregatorChoice.equals(pluginID)) continue;
            consoleLogger.config(String.valueOf(Messages.getString("BTGApplication.24")) + pluginID);
            this.aggregator = dataAggregatorInstance;
        }
        if (this.aggregator != null) {
            descriptorsList = this.aggregator.aggregateSDDData(sddFragments, this.aggregatorProperties, false);
        } else {
            consoleLogger.config(Messages.getString("BTGApplication.25"));
        }
        return descriptorsList;
    }

    public Collection<BTGProperty> getSupportedProperties() {
        ArrayList<BTGProperty> properties = new ArrayList<BTGProperty>();
        properties.add(new BTGProperty(OUTPUT_FILEBASE_PROPERTY, true));
        return properties;
    }

    public void writeDescriptorsToFiles(Collection<Document> descriptors, String fileNameBase) throws XMLValidationException, IOException {
        SDD_DAS sddDas = ValidationFactory.DEFAULT_INSTANCE.createSDD_DAS();
        if (descriptors != null && descriptors.size() > 2) {
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.18"));
        }
        if (descriptors != null) {
            boolean foundPd = false;
            for (Document descriptor : descriptors) {
                if (descriptor == null) continue;
                String nodeName = descriptor.getDocumentElement().getNodeName();
                if (nodeName.indexOf(58) != -1) {
                    nodeName = nodeName.split(":")[1];
                }
                if (!PD_NODENAME.equals(nodeName)) continue;
                foundPd = true;
                FileOutputStream pdOutStream = new FileOutputStream(String.valueOf(fileNameBase) + ".pd.xml");
                sddDas.saveDocument(descriptor, (OutputStream)pdOutStream, null, false);
                ((OutputStream)pdOutStream).close();
                if (!this.printToConsole) continue;
                consoleLogger.info("\n\n**************************************");
                consoleLogger.info(Messages.getString("BTGApplication.45"));
                consoleLogger.info("**************************************\n");
                sddDas.saveDocument(descriptor, (OutputStream)System.out, null, false);
            }
            if (!foundPd) {
                consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.11"));
            }
            boolean foundDd = false;
            for (Document descriptor : descriptors) {
                if (descriptor == null) continue;
                String nodeName = descriptor.getDocumentElement().getNodeName();
                if (nodeName.indexOf(58) != -1) {
                    nodeName = nodeName.split(":")[1];
                }
                if (!DD_NODENAME.equals(nodeName)) continue;
                foundDd = true;
                FileOutputStream ddOutStream = new FileOutputStream(String.valueOf(fileNameBase) + ".dd.xml");
                sddDas.saveDocument(descriptor, (OutputStream)ddOutStream, null, false);
                ((OutputStream)ddOutStream).close();
                if (!this.printToConsole) continue;
                consoleLogger.info("\n**************************************");
                consoleLogger.info(Messages.getString("BTGApplication.44"));
                consoleLogger.info("**************************************\n");
                sddDas.saveDocument(descriptor, (OutputStream)System.out, null, false);
            }
            if (!foundDd) {
                consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.13"));
            }
        } else {
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.11"));
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.13"));
        }
    }

    private void showHelp() {
        consoleLogger.info(Messages.getString("BTGApplication.38"));
        consoleLogger.info(Messages.getString("BTGApplication.39"));
        consoleLogger.info(Messages.getString("BTGApplication.40"));
    }

    private void showUsage() {
        consoleLogger.info(Messages.getString("BTGApplication.41"));
        consoleLogger.info(Messages.getString("BTGApplication.42"));
    }
}

