/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.cosmos.me.internal.deployment.sdd.resources.tooling.btg.Messages;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.util.BTGLogUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertiesReader {
    File propertiesFile = null;
    public static final String ENABLED_PROPERTY = "Enabled";
    public static final String PLUGINID_PROPERTY = "PluginID";
    public static final String BTG_PLUGINID = "org.eclipse.cosmos.me.deployment.sdd.tooling.btg";
    private static Logger logger = Logger.getLogger("org.eclipse.cosmos.me.deployment.sdd.tooling.btg");
    private static Logger consoleLogger = Logger.getLogger("org.eclipse.cosmos.me.deployment.sdd.tooling.btg.stdout");

    public PropertiesReader(String propertiesFileName) {
        this.propertiesFile = new File(propertiesFileName);
    }

    public Collection<Properties> getPropertiesList() throws FileNotFoundException, IOException, ParseException {
        BufferedReader propsFileReader = new BufferedReader(new FileReader(this.propertiesFile));
        ArrayList<Properties> propertiesList = new ArrayList<Properties>();
        boolean readBtgSection = false;
        Properties properties = this.readNextSection(propsFileReader);
        while (properties != null) {
            if ("true".equalsIgnoreCase(properties.getProperty(ENABLED_PROPERTY)) || BTG_PLUGINID.equals(properties.getProperty(PLUGINID_PROPERTY))) {
                propertiesList.add(properties);
            }
            if (BTG_PLUGINID.equals(properties.getProperty(PLUGINID_PROPERTY))) {
                if (readBtgSection) {
                    ParseException e = new ParseException(Messages.getString("PropertiesReader.4"), -1);
                    consoleLogger.severe(e.getMessage());
                    consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                    logger.log(Level.SEVERE, "ExceptionStack", e);
                    throw e;
                }
                readBtgSection = true;
            }
            properties = this.readNextSection(propsFileReader);
        }
        boolean hasBtgProps = false;
        for (Properties props : propertiesList) {
            if (!BTG_PLUGINID.equals(props.get(PLUGINID_PROPERTY))) continue;
            hasBtgProps = true;
        }
        if (!hasBtgProps) {
            ParseException e = new ParseException(Messages.getString("PropertiesReader.6", BTG_PLUGINID), -1);
            consoleLogger.severe(e.getMessage());
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, "ExceptionStack", e);
            throw e;
        }
        return propertiesList;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Properties readNextSection(BufferedReader propertiesReader) throws IOException, ParseException {
        String[] inserts;
        Properties properties = new Properties();
        String line = propertiesReader.readLine();
        if (line == null) {
            return null;
        }
        line = line.trim();
        while (!this.isSectionHeader(line) && (this.isComment(line) || this.isBlankLine(line))) {
            line = propertiesReader.readLine();
            if (line == null) {
                return null;
            }
            line = line.trim();
        }
        if (!this.isSectionHeader(line)) {
            ParseException e = new ParseException(Messages.getString("PropertiesReader.7", line), -1);
            consoleLogger.severe(e.getMessage());
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, "ExceptionStack", e);
            throw e;
        }
        properties.put(PLUGINID_PROPERTY, this.getPluginId(line));
        int propsCount = properties.size();
        propertiesReader.mark(8192);
        line = propertiesReader.readLine();
        if (line == null) {
            ParseException e = new ParseException(Messages.getString("PropertiesReader.8", properties.getProperty(PLUGINID_PROPERTY)), -1);
            consoleLogger.severe(e.getMessage());
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, "ExceptionStack", e);
            throw e;
        }
        line = line.trim();
        while (line != null && !this.isSectionHeader(line)) {
            if (!this.isComment(line) && !this.isBlankLine(line)) {
                if (this.getPropertyName(line) == null) {
                    String[] inserts2 = new String[]{line, properties.getProperty(PLUGINID_PROPERTY)};
                    ParseException e = new ParseException(Messages.getString("PropertiesReader.10", inserts2), -1);
                    consoleLogger.severe(e.getMessage());
                    consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                    logger.log(Level.SEVERE, "ExceptionStack", e);
                    throw e;
                }
                String propertyName = this.getPropertyName(line);
                if (this.isDuplicateProperty(propertyName, properties)) {
                    inserts = new String[]{propertyName, properties.getProperty(PLUGINID_PROPERTY)};
                    ParseException e = new ParseException(Messages.getString("PropertiesReader.12", inserts), -1);
                    consoleLogger.severe(e.getMessage());
                    consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                    logger.log(Level.SEVERE, "ExceptionStack", e);
                    throw e;
                }
                String propertyValue = this.getPropertyValue(line);
                if (propertyValue == null) {
                    String[] inserts3 = new String[]{line, properties.getProperty(PLUGINID_PROPERTY)};
                    ParseException e = new ParseException(Messages.getString("PropertiesReader.14", inserts3), -1);
                    consoleLogger.severe(e.getMessage());
                    consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
                    logger.log(Level.SEVERE, "ExceptionStack", e);
                    throw e;
                }
                properties.put(propertyName, propertyValue);
            }
            propertiesReader.mark(8192);
            line = propertiesReader.readLine();
            if (line == null) continue;
            line = line.trim();
        }
        if (this.isSectionHeader(line)) {
            propertiesReader.reset();
        }
        if (properties.size() <= propsCount) {
            ParseException e = new ParseException(Messages.getString("PropertiesReader.16", properties.getProperty(PLUGINID_PROPERTY)), -1);
            consoleLogger.severe(e.getMessage());
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, "ExceptionStack", e);
            throw e;
        }
        boolean hasEnabled = false;
        for (Object propertyNameObj : properties.keySet()) {
            String propertyName = (String)propertyNameObj;
            if (!ENABLED_PROPERTY.equals(propertyName)) continue;
            hasEnabled = true;
        }
        if (!hasEnabled && !BTG_PLUGINID.equals(properties.getProperty(PLUGINID_PROPERTY))) {
            inserts = new String[]{properties.getProperty(PLUGINID_PROPERTY), ENABLED_PROPERTY};
            ParseException e = new ParseException(Messages.getString("PropertiesReader.18", inserts), -1);
            consoleLogger.severe(e.getMessage());
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, "ExceptionStack", e);
            throw e;
        }
        return properties;
    }

    private boolean isSectionHeader(String line) {
        if (line == null) {
            return false;
        }
        return line.startsWith("[") && line.endsWith("]") && line.indexOf("[") < line.lastIndexOf("]") - 1;
    }

    private boolean isComment(String line) {
        if (line == null) {
            return false;
        }
        return line.startsWith("#");
    }

    private boolean isBlankLine(String line) {
        if (line == null) {
            return false;
        }
        return line.length() == 0;
    }

    private String getPluginId(String line) {
        int openingBracket = line.indexOf("[");
        int closingBracket = line.lastIndexOf("]");
        return line.substring(openingBracket + 1, closingBracket);
    }

    private String getPropertyName(String line) {
        int equalIndex = line.indexOf("=");
        if (equalIndex == -1) {
            return null;
        }
        String propertyName = line.substring(0, equalIndex).trim();
        if (propertyName.length() == 0) {
            return null;
        }
        return propertyName;
    }

    private String getPropertyValue(String line) {
        int equalIndex = line.indexOf("=");
        if (equalIndex == -1) {
            return null;
        }
        String propertyValue = line.substring(equalIndex + 1).trim();
        if (propertyValue.length() == 0) {
            return null;
        }
        return propertyValue;
    }

    private boolean isDuplicateProperty(String propertyName, Properties props) {
        for (Object nextNameObj : props.keySet()) {
            String nextName = (String)nextNameObj;
            if (!propertyName.equals(nextName)) continue;
            return true;
        }
        return false;
    }

    public void checkSupportedProperties(Properties props, Collection<BTGProperty> supportedProps) throws ParseException {
        if (BTG_PLUGINID.equals(props.getProperty(PLUGINID_PROPERTY)) && props.getProperty(ENABLED_PROPERTY) != null) {
            String[] inserts = new String[]{props.getProperty(PLUGINID_PROPERTY), ENABLED_PROPERTY};
            ParseException e = new ParseException(Messages.getString("PropertiesReader.30", inserts), -1);
            consoleLogger.severe(e.getMessage());
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, "ExceptionStack", e);
            throw e;
        }
        for (Object propertyNameObj : props.keySet()) {
            String propertyName = (String)propertyNameObj;
            if (PLUGINID_PROPERTY.equals(propertyName) || ENABLED_PROPERTY.equals(propertyName)) continue;
            boolean supported = false;
            for (BTGProperty supportedProp : supportedProps) {
                if (!propertyName.equals(supportedProp.getName())) continue;
                supported = true;
            }
            if (supported) continue;
            String[] inserts = new String[]{props.getProperty(PLUGINID_PROPERTY), propertyName};
            ParseException e = new ParseException(Messages.getString("PropertiesReader.30", inserts), -1);
            consoleLogger.severe(e.getMessage());
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, "ExceptionStack", e);
            throw e;
        }
        for (BTGProperty supportedProp : supportedProps) {
            if (!supportedProp.isRequired()) continue;
            boolean requiredPresent = false;
            for (Object propertyObj : props.keySet()) {
                String property = (String)propertyObj;
                if (!property.equals(supportedProp.getName())) continue;
                requiredPresent = true;
            }
            if (requiredPresent) continue;
            String[] inserts = new String[]{props.getProperty(PLUGINID_PROPERTY), supportedProp.getName()};
            ParseException e = new ParseException(Messages.getString("PropertiesReader.32", inserts), -1);
            consoleLogger.severe(e.getMessage());
            consoleLogger.log(Level.INFO, Messages.getString("BTGApplication.30"), BTGLogUtil.getMsgLogName());
            logger.log(Level.SEVERE, "ExceptionStack", e);
            throw e;
        }
    }
}

