/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.validation;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.SDD_DASImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.util.ValidatorUtils;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.SDDManager;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.SDD_DAS;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.ValidationRule;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.XMLValidationError;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.exception.XMLValidationException;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SDDManagerImpl
implements SDDManager {
    private Collection<Descriptor> descriptorsList = new Vector<Descriptor>();
    private Collection<ValidationRule> ddValidationRules = new Vector<ValidationRule>();
    private Collection<ValidationRule> pdValidationRules = new Vector<ValidationRule>();
    private String encoding = null;
    private static final String DD_ROOT_ELEMENT = "DeploymentDescriptor";
    private static final String PD_ROOT_ELEMENT = "PackageDescriptor";

    @Override
    public void addDescriptorFromDocument(Document descriptorDocument, File descriptorFile) throws IllegalArgumentException {
        int descriptorType;
        SDD_DASImpl sddDas = null;
        if (descriptorDocument == null || descriptorFile == null) {
            throw new IllegalArgumentException();
        }
        if (ValidatorUtils.nodeNameEquals(descriptorDocument.getDocumentElement(), DD_ROOT_ELEMENT)) {
            descriptorType = 1;
            sddDas = new SDD_DASImpl();
            for (ValidationRule rule : this.ddValidationRules) {
                sddDas.addValidation(rule);
            }
        } else if (ValidatorUtils.nodeNameEquals(descriptorDocument.getDocumentElement(), PD_ROOT_ELEMENT)) {
            descriptorType = 2;
            sddDas = new SDD_DASImpl();
            for (ValidationRule rule : this.pdValidationRules) {
                sddDas.addValidation(rule);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.descriptorsList.add(new Descriptor(descriptorDocument, descriptorFile, sddDas, descriptorType));
    }

    @Override
    public Document addDescriptorFromFile(File descriptorFile) throws IllegalArgumentException, FileNotFoundException, IOException, XMLValidationException {
        int descriptorType;
        SDD_DASImpl sddDas = null;
        if (descriptorFile == null) {
            throw new IllegalArgumentException();
        }
        SDD_DASImpl mySddDas = new SDD_DASImpl();
        Document document = mySddDas.loadDocument(new FileInputStream(descriptorFile));
        if (ValidatorUtils.nodeNameEquals(document.getDocumentElement(), DD_ROOT_ELEMENT)) {
            descriptorType = 1;
            sddDas = new SDD_DASImpl();
            for (ValidationRule rule : this.ddValidationRules) {
                sddDas.addValidation(rule);
            }
        } else if (ValidatorUtils.nodeNameEquals(document.getDocumentElement(), PD_ROOT_ELEMENT)) {
            descriptorType = 2;
            sddDas = new SDD_DASImpl();
            for (ValidationRule rule : this.pdValidationRules) {
                sddDas.addValidation(rule);
            }
        } else {
            throw new IllegalArgumentException();
        }
        this.descriptorsList.add(new Descriptor(document, descriptorFile, sddDas, descriptorType));
        return document;
    }

    @Override
    public void removeDescriptor(Document descriptorDocument) {
        for (Descriptor descriptor : this.descriptorsList) {
            if (descriptor.getDocument() != descriptorDocument) continue;
            this.descriptorsList.remove(descriptorDocument);
        }
    }

    @Override
    public void addValidation(ValidationRule validationRule, int descriptorType) throws IllegalArgumentException {
        if (validationRule == null) {
            throw new IllegalArgumentException();
        }
        if (descriptorType != 1 && descriptorType != 2) {
            throw new IllegalArgumentException();
        }
        for (Descriptor descriptor : this.descriptorsList) {
            if (descriptor.getType() != descriptorType) continue;
            descriptor.getDAS().addValidation(validationRule);
        }
        switch (descriptorType) {
            case 1: {
                this.ddValidationRules.add(validationRule);
                break;
            }
            case 2: {
                this.pdValidationRules.add(validationRule);
            }
        }
    }

    @Override
    public void removeValidation(ValidationRule validationRule, int descriptorType) throws IllegalArgumentException {
        if (descriptorType != 1 && descriptorType != 2) {
            throw new IllegalArgumentException();
        }
        for (Descriptor descriptor : this.descriptorsList) {
            if (descriptor.getType() != descriptorType) continue;
            descriptor.getDAS().removeValidation(validationRule);
        }
        switch (descriptorType) {
            case 1: {
                this.ddValidationRules.remove(validationRule);
                break;
            }
            case 2: {
                this.pdValidationRules.remove(validationRule);
            }
        }
    }

    @Override
    public Collection<Document> getDeploymentDescriptors() {
        Vector<Document> documents = new Vector<Document>();
        for (Descriptor descriptor : this.descriptorsList) {
            if (descriptor.getType() != 1) continue;
            documents.add(descriptor.getDocument());
        }
        return documents;
    }

    @Override
    public Collection<Document> getPackageDescriptors() {
        Vector<Document> documents = new Vector<Document>();
        for (Descriptor descriptor : this.descriptorsList) {
            if (descriptor.getType() != 2) continue;
            documents.add(descriptor.getDocument());
        }
        return documents;
    }

    @Override
    public Collection<Document> getAllDescriptors() {
        Vector<Document> documents = new Vector<Document>();
        for (Descriptor descriptor : this.descriptorsList) {
            documents.add(descriptor.getDocument());
        }
        return documents;
    }

    @Override
    public Collection<XMLValidationError> validateAllDescriptors() {
        return this.validateDescriptors(this.getAllDescriptors());
    }

    @Override
    public Collection<XMLValidationError> validateDescriptors(Collection<Document> descriptorDocs) {
        Vector<XMLValidationError> xmlValidationErrors = new Vector<XMLValidationError>();
        for (Descriptor descriptor : this.descriptorsList) {
            for (Document descriptorDoc : descriptorDocs) {
                if (descriptor.getDocument() != descriptorDoc) continue;
                try {
                    Collection<XMLValidationError> validationErrors = descriptor.getDAS().validate(descriptor.getDocument());
                    xmlValidationErrors.addAll(validationErrors);
                }
                catch (IllegalArgumentException illegalArgumentException) {}
            }
        }
        return xmlValidationErrors;
    }

    @Override
    public void writeAllDescriptors(boolean performValidation) throws XMLValidationException, IOException {
        this.writeDescriptors(this.getAllDescriptors(), performValidation);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void writeDescriptors(Collection<Document> descriptorDocs, boolean performValidation) throws XMLValidationException, IOException {
        xmlValidationErrors = new Vector<XMLValidationError>();
        for (Descriptor descriptor : this.descriptorsList) {
            block3: for (Document descriptorDoc : descriptorDocs) {
                if (descriptor.getDocument() != descriptorDoc) continue;
                try {
                    descriptor.getDAS().saveDocument(descriptor.getDocument(), new FileOutputStream(descriptor.getXmlFile()), this.encoding, performValidation);
                    continue;
                }
                catch (XMLValidationException e) {
                    errorIter = e.getValidationErrorIterator();
                    ** while (errorIter.hasNext())
                }
lbl-1000:
                // 1 sources

                {
                    xmlValidationErrors.add(errorIter.next());
                    continue;
lbl14:
                    // 1 sources

                }
            }
        }
        if (!xmlValidationErrors.isEmpty()) {
            throw new XMLValidationException(xmlValidationErrors);
        }
    }

    @Override
    public Collection<ValidationRule> getPackageDescriptorRules() {
        return this.pdValidationRules;
    }

    @Override
    public Collection<ValidationRule> getDeploymentDescriptorRules() {
        return this.ddValidationRules;
    }

    @Override
    public Collection<ValidationRule> getAllValidationRules() {
        Vector<ValidationRule> validationRules = new Vector<ValidationRule>();
        validationRules.addAll(this.ddValidationRules);
        validationRules.addAll(this.pdValidationRules);
        return validationRules;
    }

    @Override
    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private class Descriptor {
        Document document;
        File xmlFile;
        SDD_DAS DAS;
        int type;

        public Descriptor(Document document, File xmlFile, SDD_DAS DAS, int type) {
            this.document = document;
            this.xmlFile = xmlFile;
            this.DAS = DAS;
            this.type = type;
        }

        public Document getDocument() {
            return this.document;
        }

        public void setDocument(Document document) {
            this.document = document;
        }

        public int getType() {
            return this.type;
        }

        public void setType(int type) {
            this.type = type;
        }

        public File getXmlFile() {
            return this.xmlFile;
        }

        public void setXmlFile(File xmlFile) {
            this.xmlFile = xmlFile;
        }

        public SDD_DAS getDAS() {
            return this.DAS;
        }

        public void setDAS(SDD_DAS DAS) {
            this.DAS = DAS;
        }
    }
}

