/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FixIdentityImpl
extends DescribableObject
implements FixIdentity {
    private static final String FIX_IDENTITY_TYPE = "sdd-common:FixIdentityType";

    public FixIdentityImpl(Element data, SPISessionImpl session) {
        super(data, session, FIX_IDENTITY_TYPE);
    }

    @Override
    public String getFixName() {
        String fixName = null;
        if (this.isSetElement("Name")) {
            fixName = this.getChild("Name").getTextContent();
        }
        return fixName;
    }

    @Override
    public Collection<TranslatableString> getSymptoms() {
        ArrayList<TranslatableString> symptoms = new ArrayList<TranslatableString>();
        if (this.isSetElement("Symptom")) {
            Collection<Element> symptomElements = this.getChildren("Symptom");
            for (Element symptom : symptomElements) {
                symptoms.add(new TranslatableString(symptom));
            }
        }
        return symptoms;
    }

    @Override
    public void setFixName(String fixName) {
        this.session.testParameter(fixName, 1, null);
        if (fixName == null) {
            this.unSetElement("Name");
        } else {
            Element fixNameElement = this.session.createCommonElement("Name");
            fixNameElement.setTextContent(fixName);
            this.setContent(fixNameElement);
        }
    }

    @Override
    public void setSymptoms(Collection<TranslatableString> symptoms) {
        if (symptoms == null) {
            this.unSetElement("Symptom");
        } else {
            ArrayList<Element> symptomElements = new ArrayList<Element>();
            this.removeContent(this.getChildren("Symptom", false));
            for (TranslatableString symptom : symptoms) {
                Element element = this.session.createCommonElement("Symptom");
                element.setTextContent(symptom.getValue());
                element.setAttribute("translationKey", symptom.getTranslationKey());
                symptomElements.add(element);
            }
            this.addContent(symptomElements);
        }
    }

    @Override
    public Object clone() {
        return new FixIdentityImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    @Override
    public String toString() {
        String fixIdentityContents = new String("Fix name: " + this.getFixName() + "\n" + super.toString());
        Collection<TranslatableString> symptoms = this.getSymptoms();
        if (symptoms.size() > 0) {
            fixIdentityContents = String.valueOf(fixIdentityContents) + "Symptoms:\n";
            for (TranslatableString symptom : symptoms) {
                fixIdentityContents = String.valueOf(fixIdentityContents) + " - \"" + symptom.getValue() + "\"\n";
            }
        }
        return fixIdentityContents;
    }
}

