/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.Location;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ManufacturerInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

public class ManufacturerInformationImpl
extends SPIDataObject
implements ManufacturerInformation {
    private static final String MANUFACTURER_INFORMATION_TYPE = "sdd-common:ManufacturerType";

    public ManufacturerInformationImpl(Element data, SPISessionImpl session) {
        super(data, session, MANUFACTURER_INFORMATION_TYPE);
    }

    public TranslatableString getAddress() {
        Location location;
        TranslatableString address = null;
        if (this.isSetElement("Location") && (location = new Location(this.getChild("Location"), this.session)).isSetAddress()) {
            address = location.getAddress();
        }
        return address;
    }

    public TranslatableString getContactInformation() {
        TranslatableString contactInfo = null;
        if (this.isSetElement("ContactInformation")) {
            Element contactElement = this.getChild("ContactInformation");
            contactInfo = new TranslatableString(contactElement);
        }
        return contactInfo;
    }

    public TranslatableString getCountry() {
        Location location;
        TranslatableString country = null;
        if (this.isSetElement("Location") && (location = new Location(this.getChild("Location"), this.session)).isSetCountry()) {
            country = location.getCountry();
        }
        return country;
    }

    public TranslatableString getName() {
        TranslatableString name = null;
        if (this.isSetElement("Name")) {
            Element nameElement = this.getChild("Name");
            name = new TranslatableString(nameElement);
        }
        return name;
    }

    public void setAddress(TranslatableString address) {
        if (address == null && this.isSetElement("Location")) {
            Location location = new Location(this.getChild("Location"), this.session);
            if (!location.isSetCountry()) {
                this.unSetElement("Location");
            } else {
                location.unSetElement("Address");
                this.setContent(location);
            }
        } else if (address != null) {
            Location location = null;
            location = this.isSetElement("Location") ? new Location(this.getChild("Location"), this.session) : new Location(this.session.createCommonElement("Location"), this.session);
            location.setAddress(address);
            this.setContent(location);
        }
    }

    public void setContactInformation(TranslatableString contactInformation) {
        if (contactInformation == null) {
            this.unSetElement("ContactInformation");
        } else {
            Element element = this.session.createCommonElement("ContactInformation");
            element.setAttribute("translationKey", contactInformation.getTranslationKey());
            element.setTextContent(contactInformation.getValue());
            this.setContent(element);
        }
    }

    public void setCountry(TranslatableString country) {
        if (country == null && this.isSetElement("Location")) {
            Location location = new Location(this.getChild("Location"), this.session);
            if (!location.isSetAddress()) {
                this.unSetElement("Location");
            } else {
                location.unSetElement("Country");
                this.setContent(location);
            }
        } else if (country != null) {
            Location location = null;
            location = this.isSetElement("Location") ? new Location(this.getChild("Location"), this.session) : new Location(this.session.createCommonElement("Location"), this.session);
            location.setCountry(country);
            this.setContent(location);
        }
    }

    public void setName(TranslatableString name) {
        this.session.testParameter(name, 1, null);
        if (name == null) {
            this.unSetElement("Name");
        } else {
            Element element = this.session.createCommonElement("Name");
            element.setAttribute("translationKey", name.getTranslationKey());
            element.setTextContent(name.getValue());
            this.setContent(element);
        }
    }

    public Object clone() {
        return new ManufacturerInformationImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

