/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.IdentityImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageIdentity;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageIdentityImpl
extends IdentityImpl
implements PackageIdentity {
    private static final String PACKAGE_IDENTITY_TYPE = "sdd-pd:PackageIdentityType";

    public PackageIdentityImpl(Element data, SPISessionImpl session) {
        super(data, session, PACKAGE_IDENTITY_TYPE);
    }

    @Override
    public Collection<String> getPackageTypes() {
        String packageTypesList = this.getAttribute("packageType");
        ArrayList<String> packageTypes = new ArrayList<String>();
        if (packageTypesList != null && packageTypesList.length() > 0) {
            String[] tokens;
            String[] stringArray = tokens = packageTypesList.split(" ");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                packageTypes.add(token);
                ++n2;
            }
        }
        return packageTypes;
    }

    @Override
    public String getContentType() {
        return this.getAttribute("contentType");
    }

    @Override
    public String getLabel() {
        return this.getAttribute("label");
    }

    @Override
    public void setContentType(String contentType) {
        this.setAttribute("contentType", contentType);
    }

    @Override
    public void setLabel(String label) {
        this.setAttribute("label", label);
    }

    @Override
    public void setPackageTypes(Collection<String> packageTypes) {
        if (packageTypes == null || packageTypes.size() == 0) {
            this.unSetAttribute("packageType");
        } else {
            String packageTypeString = "";
            for (String packageType : packageTypes) {
                packageTypeString = String.valueOf(packageTypeString) + packageType + " ";
            }
            packageTypeString = packageTypeString.substring(0, packageTypeString.length() - 1);
            this.setAttribute("packageType", packageTypeString);
        }
    }

    @Override
    public Object clone() {
        return new PackageIdentityImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    @Override
    public String toString() {
        String packageIdentityContents = "Package Types: " + this.getPackageTypes() + "\n";
        if (this.isSetAttribute("contentType")) {
            packageIdentityContents = String.valueOf(packageIdentityContents) + "Content Type: " + this.getContentType() + "\n";
        }
        if (this.isSetAttribute("label")) {
            packageIdentityContents = String.valueOf(packageIdentityContents) + "Label: " + this.getLabel() + "\n";
        }
        return String.valueOf(packageIdentityContents) + super.toString();
    }
}

