/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ResourceMapImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ResultingChangeMapImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.ResultingResourceMapImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactArgument;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ContentSelectionFeatureImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LanguageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.OutputVariableImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResultingChangeMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResultingResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentSelectionFeature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.OutputVariable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReferencedPackageImpl
extends SPIDataObject
implements ReferencedPackage {
    private static final String REFERENCED_PACKAGE_TYPE = "sdd-dd:ReferencedPackageType";
    private static final String ARGUMENT_LIST_TYPE = "sdd-dd:ArgumentListType";
    private static final String LANGUAGES_TYPE = "sdd-dd:LanguagesType";
    private static final String OUTPUT_VARIABLE_LIST_TYPE = "sdd-dd:OutputVariableListType";
    private static final String REQUIRED_CONTENT_SELECTION_TYPE = "sdd-dd:RequiredContentSelectionType";
    private static final String REQUIREMENTS_TYPE = "sdd-dd:RequirementsType";

    public ReferencedPackageImpl(Element rpdo, SPISessionImpl session) {
        super(rpdo, session, REFERENCED_PACKAGE_TYPE);
    }

    @Override
    public Collection<ArtifactArgument> getArguments() {
        ArrayList<ArtifactArgument> arguments = new ArrayList<ArtifactArgument>();
        if (this.isSetElement("Arguments")) {
            Element argumentsElement = this.getChild("Arguments");
            Collection<Element> argumentElements = this.session.getChildren(argumentsElement, "Argument");
            for (Element argumentElement : argumentElements) {
                String name = argumentElement.getAttribute("name");
                String value = argumentElement.getAttribute("value");
                Boolean required = new Boolean(argumentElement.getAttribute("required"));
                ArtifactArgument argument = new ArtifactArgument(name, value, required);
                arguments.add(argument);
            }
        }
        return arguments;
    }

    @Override
    public String getReferencedPackageID() {
        return this.getAttribute("id");
    }

    @Override
    public String getOperation() {
        return this.getAttribute("operation");
    }

    @Override
    public String getContentReference() {
        return this.getAttribute("contentRef");
    }

    @Override
    public Collection<Language> getLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>();
        if (this.isSetElement("Languages")) {
            Element languagesElement = this.getChild("Languages");
            Collection<Element> languageElements = this.session.getChildren(languagesElement, "Language");
            for (Element element : languageElements) {
                LanguageImpl language = new LanguageImpl(element, this.session);
                languages.add(language);
            }
        }
        return languages;
    }

    @Override
    public Collection<OutputVariable> getOutputVariables() {
        ArrayList<OutputVariable> outputVariables = new ArrayList<OutputVariable>();
        if (this.isSetElement("OutputVariables")) {
            Element variablesElement = this.getChild("OutputVariables");
            Collection<Element> variableElements = this.session.getChildren(variablesElement, "OutputVariable");
            for (Element element : variableElements) {
                OutputVariableImpl outputVariable = new OutputVariableImpl(element, this.session);
                outputVariables.add(outputVariable);
            }
        }
        return outputVariables;
    }

    @Override
    public Collection<ResultingChangeMap> getResultingChangeMaps() {
        ArrayList<ResultingChangeMap> resultingChangeMaps = new ArrayList<ResultingChangeMap>();
        if (this.isSetElement("ResultingChangeMap")) {
            Collection<Element> resultingChangeElements = this.getChildren("ResultingChangeMap");
            for (Element resultingChangeElement : resultingChangeElements) {
                ResultingChangeMapImpl resultingChangeMap = new ResultingChangeMapImpl(resultingChangeElement, this.session);
                resultingChangeMaps.add(resultingChangeMap);
            }
        }
        return resultingChangeMaps;
    }

    @Override
    public Collection<ResultingResourceMap> getResultingResourceMaps() {
        ArrayList<ResultingResourceMap> resultingResourceMaps = new ArrayList<ResultingResourceMap>();
        if (this.isSetElement("ResultingResourceMap")) {
            Collection<Element> resultingResourceElements = this.getChildren("ResultingResourceMap");
            for (Element resultingResourceElement : resultingResourceElements) {
                ResultingResourceMapImpl resultingResourceMap = new ResultingResourceMapImpl(resultingResourceElement, this.session);
                resultingResourceMaps.add(resultingResourceMap);
            }
        }
        return resultingResourceMaps;
    }

    @Override
    public Collection<ResourceMap> getRequiredResourceMaps() {
        ArrayList<ResourceMap> requiredResourceMaps = new ArrayList<ResourceMap>();
        if (this.isSetElement("RequiredResourceMap")) {
            Collection<Element> requiredResourceElements = this.getChildren("RequiredResourceMap");
            for (Element requiredResourceElement : requiredResourceElements) {
                ResourceMapImpl requiredResourceMap = new ResourceMapImpl(requiredResourceElement, this.session);
                requiredResourceMaps.add(requiredResourceMap);
            }
        }
        return requiredResourceMaps;
    }

    @Override
    public Collection<ContentSelectionFeature> getRequiredFeatures() {
        ArrayList<ContentSelectionFeature> requiredFeatures = new ArrayList<ContentSelectionFeature>();
        if (this.isSetElement("RequiredContentSelection")) {
            Element contentSelectionElement = this.getChild("RequiredContentSelection");
            Collection<Element> featureElements = this.session.getChildren(contentSelectionElement, "Feature");
            for (Element element : featureElements) {
                ContentSelectionFeatureImpl contentSelectionFeature = new ContentSelectionFeatureImpl(element, this.session);
                requiredFeatures.add(contentSelectionFeature);
            }
        }
        return requiredFeatures;
    }

    @Override
    public String getRequiredGroup() {
        Element contentSelectionElement;
        Collection<Element> groupElements;
        String requiredGroup = null;
        if (this.isSetElement("RequiredContentSelection") && (groupElements = this.session.getChildren(contentSelectionElement = this.getChild("RequiredContentSelection"), "Group")) != null && !groupElements.isEmpty()) {
            requiredGroup = groupElements.iterator().next().getTextContent();
        }
        return requiredGroup;
    }

    @Override
    public Collection<Requirement> getRequirements() {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        if (this.isSetElement("Requirements")) {
            Element requirementsElement = this.getChild("Requirements");
            Collection<Element> requirementElements = this.session.getChildren(requirementsElement, "Requirement");
            for (Element element : requirementElements) {
                RequirementImpl requirement = new RequirementImpl(element, this.session);
                requirements.add(requirement);
            }
        }
        return requirements;
    }

    @Override
    public BigInteger getWeight() {
        if (this.isSetAttribute("weight")) {
            BigInteger weight = new BigInteger(this.getAttribute("weight"));
            return weight;
        }
        return null;
    }

    @Override
    public void setArguments(Collection<ArtifactArgument> arguments) {
        if (arguments == null) {
            this.unSetElement("Arguments");
        } else {
            Element argumentListElement = this.session.createDeploymentElement("Arguments");
            for (ArtifactArgument argument : arguments) {
                Element argumentElement = this.session.createDeploymentElement("Argument");
                argumentElement.setAttribute("name", argument.getName());
                if (argument.getValue() != null) {
                    argumentElement.setAttribute("value", argument.getValue());
                }
                if (argument.getRequired() != null) {
                    argumentElement.setAttribute("required", argument.getRequired().toString());
                }
                this.session.insertNode((Node)argumentListElement, (Node)argumentElement, ARGUMENT_LIST_TYPE);
            }
            this.setContent(argumentListElement);
        }
    }

    @Override
    public void setReferencedPackageID(String id) {
        this.session.testParameter(id, 1, null);
        this.setAttribute("id", id);
    }

    @Override
    public void setOperation(String operation) {
        this.setAttribute("operation", operation);
    }

    @Override
    public void setContentReference(String ref) {
        this.session.testParameter(ref, 1, null);
        this.setAttribute("contentRef", ref);
    }

    @Override
    public void setLanguages(Collection<Language> languages) {
        if (languages == null) {
            this.unSetElement("Languages");
        } else {
            Element languagesElement = this.session.createDeploymentElement("Languages");
            for (Language language : languages) {
                this.session.insertNode((Node)languagesElement, (SPIDataObject)((Object)language), LANGUAGES_TYPE);
            }
            this.setContent(languagesElement);
        }
    }

    @Override
    public void setOutputVariables(Collection<OutputVariable> outputVariables) {
        if (outputVariables == null) {
            this.unSetElement("OutputVariables");
        } else {
            Element outputVariableListElement = this.session.createDeploymentElement("OutputVariables");
            for (OutputVariable outputVariable : outputVariables) {
                this.session.insertNode((Node)outputVariableListElement, (SPIDataObject)((Object)outputVariable), OUTPUT_VARIABLE_LIST_TYPE);
            }
            this.setContent(outputVariableListElement);
        }
    }

    @Override
    public void setRequiredFeatures(Collection<ContentSelectionFeature> features) {
        if (features != null) {
            Element contentSelectionElement;
            if (!this.isSetElement("RequiredContentSelection")) {
                contentSelectionElement = this.session.createDeploymentElement("RequiredContentSelection");
                this.setContent(contentSelectionElement);
            }
            contentSelectionElement = this.getChild("RequiredContentSelection");
            Collection<Element> featureElements = this.session.getChildren(contentSelectionElement, "Feature");
            for (Element element : featureElements) {
                contentSelectionElement.removeChild(element);
            }
            for (ContentSelectionFeature feature : features) {
                this.session.insertNode((Node)contentSelectionElement, (SPIDataObject)((Object)feature), REQUIRED_CONTENT_SELECTION_TYPE);
            }
            this.setContent(contentSelectionElement);
        }
    }

    @Override
    public void setRequiredGroup(String group) {
        if (group != null) {
            Collection<Element> groupElements;
            Element contentSelectionElement;
            if (!this.isSetElement("RequiredContentSelection")) {
                contentSelectionElement = this.session.createDeploymentElement("RequiredContentSelection");
                this.setContent(contentSelectionElement);
            }
            if ((groupElements = this.session.getChildren(contentSelectionElement = this.getChild("RequiredContentSelection"), "Group")) != null && !groupElements.isEmpty()) {
                contentSelectionElement.removeChild(groupElements.iterator().next());
            }
            Element groupElement = this.session.createDeploymentElement("Group");
            groupElement.setTextContent(group);
            this.session.insertNode((Node)contentSelectionElement, (Node)groupElement, REQUIRED_CONTENT_SELECTION_TYPE);
            this.setContent(contentSelectionElement);
        }
    }

    @Override
    public void setRequirements(Collection<Requirement> requirements) {
        if (requirements == null) {
            this.unSetElement("Requirements");
        } else {
            Element requirementsElement = this.session.createDeploymentElement("Requirements");
            for (Requirement requirement : requirements) {
                this.session.insertNode((Node)requirementsElement, (SPIDataObject)((Object)requirement), REQUIREMENTS_TYPE);
            }
            this.setContent(requirementsElement);
        }
    }

    @Override
    public void setResultingChangeMaps(Collection<ResultingChangeMap> resultingChangeMaps) {
        if (resultingChangeMaps == null) {
            this.unSetElement("ResultingChangeMap");
        } else {
            this.removeContent(this.getChildren("ResultingChangeMap", false));
            this.addContent(resultingChangeMaps);
        }
    }

    @Override
    public void setResultingResourceMaps(Collection<ResultingResourceMap> resultingResourceMaps) {
        if (resultingResourceMaps == null) {
            this.unSetElement("ResultingResourceMap");
        } else {
            this.removeContent(this.getChildren("ResultingResourceMap", false));
            this.addContent(resultingResourceMaps);
        }
    }

    @Override
    public void setRequiredResourceMaps(Collection<ResourceMap> requiredResourceMaps) {
        if (requiredResourceMaps == null) {
            this.unSetElement("RequiredResourceMap");
        } else {
            this.removeContent(this.getChildren("RequiredResourceMap", false));
            this.addContent(requiredResourceMaps);
        }
    }

    @Override
    public void setWeight(BigInteger weight) {
        if (weight == null) {
            this.unSetAttribute("weight");
        } else {
            this.setAttribute("weight", weight.toString());
        }
    }

    @Override
    public Object clone() {
        return new ReferencedPackageImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

