/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionRangeImpl
extends SPIDataObject
implements VersionRange {
    private static final String VERSION_RANGE_TYPE = "sdd-dd:VersionRangeType";

    public VersionRangeImpl(Element data, SPISessionImpl session) {
        super(data, session, VERSION_RANGE_TYPE);
    }

    @Override
    public Collection<String> getFixNames() {
        Collection<Element> fixNameElements = this.getChildren("FixName");
        ArrayList<String> fixNames = new ArrayList<String>();
        for (Element element : fixNameElements) {
            fixNames.add(element.getTextContent());
        }
        return fixNames;
    }

    @Override
    public String getMaximumVersion() {
        if (this.isSetElement("MaxVersion")) {
            Element maxVersion = this.getChild("MaxVersion");
            return maxVersion.getTextContent();
        }
        return null;
    }

    @Override
    public Boolean getMaximumVersionInclusiveness() {
        if (this.isSetElement("MaxVersion") && this.getChild("MaxVersion").getAttribute("inclusive") != null) {
            return Boolean.parseBoolean(this.getChild("MaxVersion").getAttribute("inclusive"));
        }
        return null;
    }

    @Override
    public String getMinimumVersion() {
        if (this.isSetElement("MinVersion")) {
            Element minVersion = this.getChild("MinVersion");
            return minVersion.getTextContent();
        }
        return null;
    }

    @Override
    public void setFixNames(Collection<String> fixNames) {
        this.removeContent(this.getChildren("FixName", false));
        ArrayList<Element> fixNameElements = new ArrayList<Element>();
        for (String fixName : fixNames) {
            Element fixNameElement = this.session.createDeploymentElement("FixName");
            fixNameElement.setTextContent(fixName);
            fixNameElements.add(fixNameElement);
        }
        this.addContent(fixNameElements);
    }

    @Override
    public void setMaximumVersion(String maximumVersion) {
        if (maximumVersion == null) {
            this.unSetElement("MaxVersion");
        } else {
            Element maxVersionElement = this.session.createDeploymentElement("MaxVersion");
            maxVersionElement.setTextContent(maximumVersion);
            this.setContent(maxVersionElement);
        }
    }

    @Override
    public void setMaximumVersionInclusiveness(Boolean maximumVersionInclusiveness) {
        Element maxVersionElement;
        if (!this.isSetElement("MaxVersion")) {
            maxVersionElement = this.session.createDeploymentElement("MaxVersion");
            this.setContent(maxVersionElement);
        }
        maxVersionElement = this.getChild("MaxVersion");
        if (maximumVersionInclusiveness == null) {
            maxVersionElement.removeAttribute("inclusive");
        } else {
            maxVersionElement.setAttribute("inclusive", maximumVersionInclusiveness.toString());
        }
        this.setContent(maxVersionElement);
    }

    @Override
    public void setMinimumVersion(String minimumVersion) {
        if (minimumVersion == null) {
            this.unSetElement("MinVersion");
        } else {
            Element minVersionElement = this.session.createDeploymentElement("MinVersion");
            minVersionElement.setTextContent(minimumVersion);
            this.setContent(minVersionElement);
        }
    }

    public String toString() {
        String versionRangeContents = "";
        if (this.isSetElement("MinVersion")) {
            versionRangeContents = String.valueOf(versionRangeContents) + " Min Version : " + this.getChild("MinVersion").getTextContent();
        }
        if (this.isSetElement("MaxVersion")) {
            versionRangeContents = String.valueOf(versionRangeContents) + " Max Version : " + this.getChild("MaxVersion").getTextContent();
        }
        return versionRangeContents;
    }

    @Override
    public Object clone() {
        return new VersionRangeImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

