/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.CompletionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ContentUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.ResultingChangeImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigurationUnitImpl
extends ContentUnitImpl
implements ConfigurationUnit {
    private static final String CONFIGURATION_UNIT_TYPE = "sdd-dd:ConfigurationUnitType";
    private static final String CONFIGURATION_ARTIFACTS_TYPE = "sdd-dd:ConfigurationArtifactsType";
    private static final String REQUIREMENTS_TYPE = "sdd-dd:RequirementsType";

    public ConfigurationUnitImpl(Element data, SPISessionImpl session) {
        super(data, session, CONFIGURATION_UNIT_TYPE);
    }

    @Override
    public Artifact getConfigurationArtifact() {
        Collection<Element> configArtifactList;
        ArtifactImpl configArtifact = null;
        if (this.isSetElement("Artifacts") && !(configArtifactList = this.session.getChildren(this.getChild("Artifacts"), "ConfigArtifact")).isEmpty()) {
            Element configArtifactElement = configArtifactList.iterator().next();
            configArtifact = new ArtifactImpl(configArtifactElement, this.session);
        }
        return configArtifact;
    }

    @Override
    public Collection<Completion> getCompletion() {
        Collection<Element> completionElements = this.getChildren("Completion");
        ArrayList<Completion> completions = new ArrayList<Completion>();
        for (Element element : completionElements) {
            completions.add(new CompletionImpl(element, this.session));
        }
        return completions;
    }

    @Override
    public Collection<Requirement> getRequirements() {
        ArrayList<Requirement> requirements = new ArrayList<Requirement>();
        if (this.isSetElement("Requirements")) {
            Collection<Element> requirementElementList = this.session.getChildren(this.getChild("Requirements"), "Requirement");
            for (Element element : requirementElementList) {
                requirements.add(new RequirementImpl(element, this.session));
            }
        }
        return requirements;
    }

    @Override
    public Collection<ResultingChange> getResultingChanges() {
        Collection<Element> resultingChangeElements = this.getChildren("ResultingChange");
        ArrayList<ResultingChange> resultingChanges = new ArrayList<ResultingChange>();
        for (Element element : resultingChangeElements) {
            resultingChanges.add(new ResultingChangeImpl(element, this.session));
        }
        return resultingChanges;
    }

    @Override
    public String getTargetResourceReference() {
        return this.getAttribute("targetResourceRef");
    }

    @Override
    public void setCompletion(Collection<Completion> configurationUnitCompletion) {
        if (configurationUnitCompletion != null && !configurationUnitCompletion.isEmpty()) {
            this.removeContent(this.getChildren("Completion", false));
            this.addContent(configurationUnitCompletion);
        } else {
            this.removeContent(this.getChildren("Completion", false));
        }
    }

    @Override
    public void setConfigurationArtifact(Artifact configurationArtifact) {
        this.session.testParameter(configurationArtifact, 1, null);
        Element cat = this.getChild("Artifacts");
        if (configurationArtifact == null) {
            Element artifact = this.session.getChild(cat, "ConfigArtifact");
            if (artifact != null) {
                cat.removeChild(artifact);
            }
        } else {
            this.session.insertNode((Node)cat, (SPIDataObject)((Object)configurationArtifact), CONFIGURATION_ARTIFACTS_TYPE);
            this.setContent(cat);
        }
    }

    @Override
    public void setRequirements(Collection<Requirement> newRequirements) {
        if (newRequirements != null && !newRequirements.isEmpty()) {
            Element requirementsDataObject = this.isSetElement("Requirements") ? this.getChild("Requirements") : this.session.createDeploymentElement("Requirements");
            Collection<Element> requirementNodeList = this.session.getChildren(requirementsDataObject, "Requirement");
            for (Element element : requirementNodeList) {
                requirementsDataObject.removeChild(element);
            }
            for (Requirement requirement : newRequirements) {
                this.session.insertNode((Node)requirementsDataObject, (SPIDataObject)((Object)requirement), REQUIREMENTS_TYPE);
            }
            this.setContent(requirementsDataObject);
        } else {
            this.unSetElement("Requirements");
        }
    }

    @Override
    public void setResultingChanges(Collection<ResultingChange> resultingChanges) {
        if (resultingChanges != null && !resultingChanges.isEmpty()) {
            this.removeContent(this.getChildren("ResultingResource", false));
            this.addContent(resultingChanges);
        } else {
            this.removeContent(this.getChildren("ResultingResource", false));
        }
    }

    @Override
    public void setTargetResourceReference(String targetResourceReference) {
        this.session.testParameter(targetResourceReference, 1, null);
        if (targetResourceReference == null) {
            this.unSetAttribute("targetResourceRef");
        } else {
            this.setAttribute("targetResourceRef", targetResourceReference);
        }
    }
}

