/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementResourceConstraintImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.AlternativeRequirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternativeRequirementImpl
extends NameableObject
implements AlternativeRequirement {
    private static final String ALTERNATIVE_REQUIREMENT_TYPE = "sdd-dd:AlternativeRequirementType";

    public AlternativeRequirementImpl(Element data, SPISessionImpl session) {
        super(data, session, ALTERNATIVE_REQUIREMENT_TYPE);
    }

    @Override
    public String getAlternativeRequirementID() {
        return this.isSetAttribute("id") ? this.getAttribute("id") : null;
    }

    @Override
    public BigInteger getPriority() {
        return this.isSetAttribute("priority") ? new BigInteger(this.getAttribute("priority")) : null;
    }

    @Override
    public Collection<RequirementResourceConstraint> getResourceConstraints() {
        Collection<Element> rrcElements = this.getChildren("ResourceConstraint");
        ArrayList<RequirementResourceConstraint> copiedResourceConstraintArray = new ArrayList<RequirementResourceConstraint>();
        for (Element element : rrcElements) {
            RequirementResourceConstraintImpl constraint = new RequirementResourceConstraintImpl(element, this.session);
            copiedResourceConstraintArray.add(constraint);
        }
        return copiedResourceConstraintArray;
    }

    @Override
    public void setResourceConstraints(Collection<RequirementResourceConstraint> newResourceConstraints) {
        if (newResourceConstraints != null && !newResourceConstraints.isEmpty()) {
            this.removeContent(this.getChildren("ResourceConstraint", false));
            this.addContent(newResourceConstraints);
        } else {
            this.unSetElement("ResourceConstraint");
        }
    }

    @Override
    public void setAlternativeRequirementID(String alternativeRequirementID) {
        this.session.testParameter(alternativeRequirementID, 1, null);
        this.setAttribute("id", alternativeRequirementID);
    }

    @Override
    public void setPriority(BigInteger priority) {
        if (priority == null) {
            this.unSetAttribute("priority");
        } else {
            this.setAttribute("priority", priority.toString());
        }
    }

    @Override
    public Object clone() {
        Element copiedElement = (Element)this.getElement().cloneNode(true);
        AlternativeRequirementImpl duplicate = new AlternativeRequirementImpl(copiedElement, this.session);
        return duplicate;
    }
}

