/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util.ConversionUtil;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RelationshipConstraint;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RelationshipConstraintImpl
extends DescribableObject
implements RelationshipConstraint {
    private static final String RELATIONSHIP_CONSTRAINT_TYPE = "sdd-dd:RelationshipConstraintType";
    private static final String PROPERTY_TYPE = "sdd-dd:PropertyType";

    public RelationshipConstraintImpl(Element data, SPISessionImpl session) {
        super(data, session, RELATIONSHIP_CONSTRAINT_TYPE);
    }

    public Properties getProperties() {
        Collection<Element> propertyElements = this.getChildren("Property");
        return ConversionUtil.getPropertiesFromPropertyElementList(propertyElements);
    }

    public String getRelatedResourceReference() {
        return this.getAttribute("relatedResourceRef");
    }

    public String getType() {
        return this.getAttribute("type");
    }

    public void setProperties(Properties props) {
        if (props != null) {
            ArrayList<Element> properties = new ArrayList<Element>();
            this.removeContent(this.getChildren("Property", false));
            Enumeration<Object> e = props.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = props.getProperty(key);
                Element propertyElement = this.session.createDeploymentElement("Property");
                Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
                Element valueElement = this.session.createDeploymentElement("Value");
                propertyNameElement.setTextContent(key);
                valueElement.setTextContent(value);
                this.session.insertNode((Node)propertyElement, (Node)propertyNameElement, PROPERTY_TYPE);
                this.session.insertNode((Node)propertyElement, (Node)valueElement, PROPERTY_TYPE);
                properties.add(propertyElement);
            }
            this.addContent(properties);
        } else {
            this.unSetElement("Property");
        }
    }

    public void setRelatedResourceRef(String ref) {
        if (ref == null) {
            this.unSetAttribute("relatedResourceRef");
        } else {
            this.setAttribute("relatedResourceRef", ref);
        }
    }

    public void setType(String type) {
        this.session.testParameter(type, 1, null);
        this.setAttribute("type", type);
    }

    public Object clone() {
        return new RelationshipConstraintImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

