/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.VersionRangeImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.VersionValueImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionRange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.VersionValue;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraintValue;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionConstraintValueImpl
extends SPIDataObject
implements VersionConstraintValue {
    private static final String VERSION_CONSTRAINT_VALUE_TYPE = "sdd-dd:VersionConstraintValueType";

    public VersionConstraintValueImpl(Element data, SPISessionImpl session) {
        super(data, session, VERSION_CONSTRAINT_VALUE_TYPE);
    }

    @Override
    public Collection<VersionRange> getRanges() {
        Collection<Element> rangeElements = this.getChildren("Range");
        ArrayList<VersionRange> ranges = new ArrayList<VersionRange>();
        for (Element element : rangeElements) {
            VersionRangeImpl vr = new VersionRangeImpl(element, this.session);
            ranges.add(vr);
        }
        return ranges;
    }

    @Override
    public Collection<VersionValue> getValues() {
        Collection<Element> valueElements = this.getChildren("Value");
        ArrayList<VersionValue> value = new ArrayList<VersionValue>();
        for (Element element : valueElements) {
            VersionValueImpl vv = new VersionValueImpl(element, this.session);
            value.add(vv);
        }
        return value;
    }

    @Override
    public void setRange(Collection<VersionRange> range) {
        if (range != null && !range.isEmpty()) {
            this.removeContent(this.getChildren("Range", false));
            this.addContent(range);
        } else {
            this.unSetElement("Range");
        }
    }

    @Override
    public void setValue(Collection<VersionValue> value) {
        if (value != null && !value.isEmpty()) {
            this.removeContent(this.getChildren("Value", false));
            this.addContent(value);
        } else {
            this.unSetElement("Value");
        }
    }
}

