/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.Parameter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ParameterImpl
extends NameableObject
implements Parameter {
    private static final String BASE_PARAMETER_TYPE = "sdd-dd:BaseParameterType";

    public ParameterImpl(Element data, SPISessionImpl session, String sddSchemaType) {
        super(data, session, sddSchemaType);
    }

    public ParameterImpl(Element data, SPISessionImpl session) {
        super(data, session, BASE_PARAMETER_TYPE);
    }

    @Override
    public String getDefaultValue() {
        return this.isSetAttribute("defaultValue") ? this.getAttribute("defaultValue") : null;
    }

    @Override
    public Collection<String> getOperations() {
        ArrayList<String> operations = new ArrayList<String>();
        if (this.isSetAttribute("operation")) {
            String op = this.getAttribute("operation");
            StringTokenizer st = new StringTokenizer(op);
            while (st.hasMoreTokens()) {
                operations.add(st.nextToken());
            }
        }
        return operations;
    }

    @Override
    public String getParameterID() {
        return this.getAttribute("id");
    }

    @Override
    public Boolean isRequired() {
        return this.isSetAttribute("required") ? new Boolean(this.getAttribute("required")) : null;
    }

    @Override
    public Boolean isSensitive() {
        return this.isSetAttribute("sensitive") ? new Boolean(this.getAttribute("sensitive")) : null;
    }

    @Override
    public void setDefaultValue(String defaultValue) {
        if (defaultValue == null) {
            this.unSetAttribute("defaultValue");
        } else {
            this.setAttribute("defaultValue", defaultValue);
        }
    }

    @Override
    public void setOperations(Collection<String> operations) {
        if (operations == null || operations.isEmpty()) {
            this.unSetAttribute("operation");
        } else {
            String op = "";
            for (String s : operations) {
                op = String.valueOf(op) + s + " ";
            }
            this.setAttribute("operation", op.substring(0, op.length() - 1));
        }
    }

    @Override
    public void setParameterID(String parameterID) {
        this.session.testParameter(parameterID, 1, null);
        this.setAttribute("id", parameterID);
    }

    @Override
    public void setRequired(Boolean required) {
        if (required == null) {
            this.unSetAttribute("required");
        } else {
            this.setAttribute("required", required.toString());
        }
    }

    @Override
    public void setSensitive(Boolean sensitive) {
        if (sensitive == null) {
            this.unSetAttribute("sensitive");
        } else {
            this.setAttribute("sensitive", sensitive.toString());
        }
    }
}

