/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.variable.ParameterImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.StringParameter;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StringParameterImpl
extends ParameterImpl
implements StringParameter {
    private static final String STRING_PARAMETER_TYPE = "sdd-dd:StringParameterType";

    public StringParameterImpl(Element data, SPISessionImpl session) {
        super(data, session, STRING_PARAMETER_TYPE);
    }

    @Override
    public BigInteger getMaxLength() {
        return this.isSetAttribute("maxLength") ? new BigInteger(this.getAttribute("maxLength")) : null;
    }

    @Override
    public BigInteger getMinLength() {
        return this.isSetAttribute("minLength") ? new BigInteger(this.getAttribute("minLength")) : null;
    }

    @Override
    public Collection<String> getValidValues() {
        ArrayList<String> values = new ArrayList<String>();
        Collection<Element> valueElements = this.getChildren("ValidValue");
        for (Element element : valueElements) {
            values.add(element.getTextContent());
        }
        return values;
    }

    @Override
    public String getCase() {
        return this.getAttribute("case");
    }

    @Override
    public void setMaxLength(BigInteger maxLength) {
        if (maxLength == null) {
            this.unSetAttribute("maxLength");
        } else {
            this.setAttribute("maxLength", maxLength.toString());
        }
    }

    @Override
    public void setMinLength(BigInteger minLength) {
        if (minLength == null) {
            this.unSetAttribute("minLength");
        } else {
            this.setAttribute("minLength", minLength.toString());
        }
    }

    @Override
    public void setValidValues(Collection<String> validValues) {
        ArrayList<Element> values = new ArrayList<Element>();
        this.removeContent(this.getChildren("ValidValue", false));
        for (String s : validValues) {
            if (s == null || s.length() == 0) continue;
            Element validvalue = this.session.createDeploymentElement("ValidValue");
            validvalue.setTextContent(s);
            values.add(validvalue);
        }
        this.addContent(values);
    }

    @Override
    public void setCase(String caseValue) {
        this.setAttribute("case", caseValue);
    }

    @Override
    public Object clone() {
        Element copy = (Element)this.getElement().cloneNode(true);
        StringParameterImpl duplicate = new StringParameterImpl(copy, this.session);
        return duplicate;
    }
}

