/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.MaintenanceInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.w3c.dom.Element;

public class MaintenanceInformation_Test
extends TestCase {
    MaintenanceInformation info;
    MaintenanceInformation clonedInfo;
    Element element;
    SPISessionImpl session;

    public MaintenanceInformation_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.info = SPISession.DEFAULT_INSTANCE.createBaseFactory().createMaintenanceInformation();
        TranslatableString str1 = new TranslatableString("cat1", "cat1Key");
        TranslatableString str2 = new TranslatableString("cat2", "cat2Key");
        this.info.setCategory((Collection<TranslatableString>)Arrays.asList(str1, str2));
        FixIdentity fix1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName1");
        FixIdentity fix2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName2");
        this.info.setFixIdentityDefinitions((Collection<FixIdentity>)Arrays.asList(fix1, fix2));
        this.info.setSeverity(new TranslatableString("sev", "sevKey"));
        FixIdentity fix3 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName3");
        FixIdentity fix4 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName4");
        MaintenanceInformation info1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createSupersedes();
        info1.setFixIdentityDefinitions((Collection<FixIdentity>)Arrays.asList(fix3));
        MaintenanceInformation info2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createSupersedes();
        info2.setFixIdentityDefinitions((Collection<FixIdentity>)Arrays.asList(fix4));
        this.info.setSupersedes((Collection<MaintenanceInformation>)Arrays.asList(info1, info2));
        this.clonedInfo = (MaintenanceInformation)this.info.clone();
        this.element = ((SPIDataObject)((Object)this.info)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.info)).getTranslatableStrings();
        Properties clonedProps = ((SPIDataObject)((Object)this.clonedInfo)).getTranslatableStrings();
        MaintenanceInformation_Test.assertEquals((int)3, (int)props.keySet().size());
        MaintenanceInformation_Test.assertEquals((int)3, (int)clonedProps.keySet().size());
        MaintenanceInformation_Test.assertEquals((Object)"cat1", (Object)props.get("cat1Key"));
        MaintenanceInformation_Test.assertEquals((Object)"cat2", (Object)props.get("cat2Key"));
        MaintenanceInformation_Test.assertEquals((Object)"sev", (Object)props.get("sevKey"));
        MaintenanceInformation_Test.assertEquals((Object)"cat1", (Object)clonedProps.get("cat1Key"));
        MaintenanceInformation_Test.assertEquals((Object)"cat2", (Object)clonedProps.get("cat2Key"));
        MaintenanceInformation_Test.assertEquals((Object)"sev", (Object)clonedProps.get("sevKey"));
    }

    public void testGetCategory() {
        MaintenanceInformation_Test.assertEquals((int)2, (int)this.info.getCategory().size());
        MaintenanceInformation_Test.assertEquals((String)"cat1", (String)this.info.getCategory().toArray(new TranslatableString[0])[0].getValue());
        MaintenanceInformation_Test.assertEquals((String)"cat1Key", (String)this.info.getCategory().toArray(new TranslatableString[0])[0].getTranslationKey());
        MaintenanceInformation_Test.assertEquals((String)"cat2", (String)this.info.getCategory().toArray(new TranslatableString[0])[1].getValue());
        MaintenanceInformation_Test.assertEquals((String)"cat2Key", (String)this.info.getCategory().toArray(new TranslatableString[0])[1].getTranslationKey());
        MaintenanceInformation_Test.assertEquals((int)2, (int)this.clonedInfo.getCategory().size());
        MaintenanceInformation_Test.assertEquals((String)"cat1", (String)this.clonedInfo.getCategory().toArray(new TranslatableString[0])[0].getValue());
        MaintenanceInformation_Test.assertEquals((String)"cat1Key", (String)this.clonedInfo.getCategory().toArray(new TranslatableString[0])[0].getTranslationKey());
        MaintenanceInformation_Test.assertEquals((String)"cat2", (String)this.clonedInfo.getCategory().toArray(new TranslatableString[0])[1].getValue());
        MaintenanceInformation_Test.assertEquals((String)"cat2Key", (String)this.clonedInfo.getCategory().toArray(new TranslatableString[0])[1].getTranslationKey());
        MaintenanceInformation_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "Category").size());
        MaintenanceInformation_Test.assertEquals((String)"cat1", (String)this.session.getChildren(this.element, "Category").toArray(new Element[0])[0].getTextContent());
        MaintenanceInformation_Test.assertEquals((String)"cat1Key", (String)this.session.getChildren(this.element, "Category").toArray(new Element[0])[0].getAttribute("translationKey"));
        MaintenanceInformation_Test.assertEquals((String)"cat2", (String)this.session.getChildren(this.element, "Category").toArray(new Element[0])[1].getTextContent());
        MaintenanceInformation_Test.assertEquals((String)"cat2Key", (String)this.session.getChildren(this.element, "Category").toArray(new Element[0])[1].getAttribute("translationKey"));
    }

    public void testGetFixIdentityDefinitions() {
        MaintenanceInformation_Test.assertEquals((int)2, (int)this.info.getFixIdentityDefinitions().size());
        MaintenanceInformation_Test.assertEquals((String)"fixName1", (String)this.info.getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        MaintenanceInformation_Test.assertEquals((String)"fixName2", (String)this.info.getFixIdentityDefinitions().toArray(new FixIdentity[0])[1].getFixName());
        MaintenanceInformation_Test.assertEquals((int)2, (int)this.clonedInfo.getFixIdentityDefinitions().size());
        MaintenanceInformation_Test.assertEquals((String)"fixName1", (String)this.clonedInfo.getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        MaintenanceInformation_Test.assertEquals((String)"fixName2", (String)this.clonedInfo.getFixIdentityDefinitions().toArray(new FixIdentity[0])[1].getFixName());
        MaintenanceInformation_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "Fix").size());
        MaintenanceInformation_Test.assertEquals((String)"fixName1", (String)this.session.getChildren(this.session.getChildren(this.element, "Fix").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        MaintenanceInformation_Test.assertEquals((String)"fixName2", (String)this.session.getChildren(this.session.getChildren(this.element, "Fix").toArray(new Element[0])[1], "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetSeverity() {
        MaintenanceInformation_Test.assertEquals((String)"sev", (String)this.info.getSeverity().getValue());
        MaintenanceInformation_Test.assertEquals((String)"sevKey", (String)this.info.getSeverity().getTranslationKey());
        MaintenanceInformation_Test.assertEquals((String)"sev", (String)this.clonedInfo.getSeverity().getValue());
        MaintenanceInformation_Test.assertEquals((String)"sevKey", (String)this.clonedInfo.getSeverity().getTranslationKey());
        MaintenanceInformation_Test.assertEquals((String)"sev", (String)this.session.getChildren(this.element, "Severity").toArray(new Element[0])[0].getTextContent());
        MaintenanceInformation_Test.assertEquals((String)"sevKey", (String)this.session.getChildren(this.element, "Severity").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetSupersedes() {
        MaintenanceInformation_Test.assertEquals((int)2, (int)this.info.getSupersedes().size());
        MaintenanceInformation_Test.assertEquals((String)"fixName3", (String)this.info.getSupersedes().toArray(new MaintenanceInformation[0])[0].getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        MaintenanceInformation_Test.assertEquals((String)"fixName4", (String)this.info.getSupersedes().toArray(new MaintenanceInformation[0])[1].getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        MaintenanceInformation_Test.assertEquals((int)2, (int)this.clonedInfo.getSupersedes().size());
        MaintenanceInformation_Test.assertEquals((String)"fixName3", (String)this.clonedInfo.getSupersedes().toArray(new MaintenanceInformation[0])[0].getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        MaintenanceInformation_Test.assertEquals((String)"fixName4", (String)this.clonedInfo.getSupersedes().toArray(new MaintenanceInformation[0])[1].getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        MaintenanceInformation_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "Supersedes").size());
        MaintenanceInformation_Test.assertEquals((String)"fixName3", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Supersedes").toArray(new Element[0])[0], "Fix").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        MaintenanceInformation_Test.assertEquals((String)"fixName4", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Supersedes").toArray(new Element[0])[1], "Fix").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetCategory() {
        TranslatableString str1 = new TranslatableString("cat3", "cat3Key");
        this.info.setCategory((Collection<TranslatableString>)Arrays.asList(str1));
        MaintenanceInformation_Test.assertEquals((int)1, (int)this.info.getCategory().size());
        MaintenanceInformation_Test.assertEquals((String)"cat3", (String)this.info.getCategory().toArray(new TranslatableString[0])[0].getValue());
        MaintenanceInformation_Test.assertEquals((String)"cat3Key", (String)this.info.getCategory().toArray(new TranslatableString[0])[0].getTranslationKey());
        MaintenanceInformation_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "Category").size());
        MaintenanceInformation_Test.assertEquals((String)"cat3", (String)this.session.getChildren(this.element, "Category").toArray(new Element[0])[0].getTextContent());
        MaintenanceInformation_Test.assertEquals((String)"cat3Key", (String)this.session.getChildren(this.element, "Category").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetFixIdentityDefinitions() {
        FixIdentity fix1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName5");
        this.info.setFixIdentityDefinitions((Collection<FixIdentity>)Arrays.asList(fix1));
        MaintenanceInformation_Test.assertEquals((int)1, (int)this.info.getFixIdentityDefinitions().size());
        MaintenanceInformation_Test.assertEquals((String)"fixName5", (String)this.info.getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        MaintenanceInformation_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "Fix").size());
        MaintenanceInformation_Test.assertEquals((String)"fixName5", (String)this.session.getChildren(this.session.getChildren(this.element, "Fix").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetSeverity() {
        this.info.setSeverity(new TranslatableString("differentSev", "differentSevKey"));
        MaintenanceInformation_Test.assertEquals((String)"differentSev", (String)this.info.getSeverity().getValue());
        MaintenanceInformation_Test.assertEquals((String)"differentSevKey", (String)this.info.getSeverity().getTranslationKey());
        MaintenanceInformation_Test.assertEquals((String)"differentSev", (String)this.session.getChildren(this.element, "Severity").toArray(new Element[0])[0].getTextContent());
        MaintenanceInformation_Test.assertEquals((String)"differentSevKey", (String)this.session.getChildren(this.element, "Severity").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetSupersedes() {
        FixIdentity fix6 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createFixIdentity("fixName6");
        MaintenanceInformation info1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createSupersedes();
        info1.setFixIdentityDefinitions((Collection<FixIdentity>)Arrays.asList(fix6));
        this.info.setSupersedes((Collection<MaintenanceInformation>)Arrays.asList(info1));
        MaintenanceInformation_Test.assertEquals((int)1, (int)this.info.getSupersedes().size());
        MaintenanceInformation_Test.assertEquals((String)"fixName1", (String)this.info.getFixIdentityDefinitions().toArray(new FixIdentity[0])[0].getFixName());
        MaintenanceInformation_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "Supersedes").size());
        MaintenanceInformation_Test.assertEquals((String)"fixName6", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Supersedes").toArray(new Element[0])[0], "Fix").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
    }
}

