/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.artifact.ArtifactArgument;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResultingChangeMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResultingResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentSelectionFeature;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.OutputVariable;
import org.w3c.dom.Element;

public class ReferencedPackage_Test
extends TestCase {
    ReferencedPackage referencedPackage;
    ReferencedPackage clonedReferencedPackage;
    Element element;
    SPISessionImpl session;

    public ReferencedPackage_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.referencedPackage = SPISession.DEFAULT_INSTANCE.createBaseFactory().createReferencedPackage("referencedPackageContentRef", "referencedPackageID");
        ArtifactArgument argument1 = new ArtifactArgument("arg1Name", "arg1Value", new Boolean(false));
        ArtifactArgument argument2 = new ArtifactArgument("arg2Name", "arg2Value", new Boolean(true));
        this.referencedPackage.setArguments((Collection<ArtifactArgument>)Arrays.asList(argument1, argument2));
        Language language1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang1Type");
        Language language2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang2Type");
        this.referencedPackage.setLanguages((Collection<Language>)Arrays.asList(language1, language2));
        this.referencedPackage.setOperation("argumentOperation");
        OutputVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createOutputVariable("var1ID");
        OutputVariable var2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createOutputVariable("var2ID");
        this.referencedPackage.setOutputVariables((Collection<OutputVariable>)Arrays.asList(var1, var2));
        ContentSelectionFeature feat1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createContentSelectionFeature("feature1");
        ContentSelectionFeature feat2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createContentSelectionFeature("feature2");
        this.referencedPackage.setRequiredFeatures((Collection<ContentSelectionFeature>)Arrays.asList(feat1, feat2));
        this.referencedPackage.setRequiredGroup("groupName");
        ResourceMap map1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createRequiredResourceMap("map1Ref");
        ResourceMap map2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createRequiredResourceMap("map2Ref");
        this.referencedPackage.setRequiredResourceMaps((Collection<ResourceMap>)Arrays.asList(map1, map2));
        Requirement req1 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req1ID");
        Requirement req2 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req2ID");
        this.referencedPackage.setRequirements((Collection<Requirement>)Arrays.asList(req1, req2));
        ResultingChangeMap change1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createResultingChangeMap("change1Ref");
        ResultingChangeMap change2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createResultingChangeMap("change2Ref");
        this.referencedPackage.setResultingChangeMaps((Collection<ResultingChangeMap>)Arrays.asList(change1, change2));
        ResultingResourceMap res1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createResultingResourceMap("res1Ref");
        ResultingResourceMap res2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createResultingResourceMap("res2Ref");
        this.referencedPackage.setResultingResourceMaps((Collection<ResultingResourceMap>)Arrays.asList(res1, res2));
        this.referencedPackage.setWeight(new BigInteger("2"));
        this.clonedReferencedPackage = (ReferencedPackage)this.referencedPackage.clone();
        this.element = ((SPIDataObject)((Object)this.referencedPackage)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetArguments() {
        Collection<ArtifactArgument> arguments = this.referencedPackage.getArguments();
        Collection<ArtifactArgument> clonedArguments = this.clonedReferencedPackage.getArguments();
        Collection<Element> dataObjectArguments = this.session.getChildren(this.session.getChild(this.element, "Arguments"), "Argument");
        ReferencedPackage_Test.assertEquals((int)2, (int)arguments.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)clonedArguments.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)dataObjectArguments.size());
        ReferencedPackage_Test.assertEquals((String)"arg1Name", (String)arguments.toArray(new ArtifactArgument[0])[0].getName());
        ReferencedPackage_Test.assertEquals((String)"arg1Value", (String)arguments.toArray(new ArtifactArgument[0])[0].getValue());
        ReferencedPackage_Test.assertFalse((boolean)arguments.toArray(new ArtifactArgument[0])[0].getRequired());
        ReferencedPackage_Test.assertEquals((String)"arg2Name", (String)arguments.toArray(new ArtifactArgument[0])[1].getName());
        ReferencedPackage_Test.assertEquals((String)"arg2Value", (String)arguments.toArray(new ArtifactArgument[0])[1].getValue());
        ReferencedPackage_Test.assertTrue((boolean)arguments.toArray(new ArtifactArgument[0])[1].getRequired());
        ReferencedPackage_Test.assertEquals((String)"arg1Name", (String)clonedArguments.toArray(new ArtifactArgument[0])[0].getName());
        ReferencedPackage_Test.assertEquals((String)"arg1Value", (String)clonedArguments.toArray(new ArtifactArgument[0])[0].getValue());
        ReferencedPackage_Test.assertFalse((boolean)clonedArguments.toArray(new ArtifactArgument[0])[0].getRequired());
        ReferencedPackage_Test.assertEquals((String)"arg2Name", (String)clonedArguments.toArray(new ArtifactArgument[0])[1].getName());
        ReferencedPackage_Test.assertEquals((String)"arg2Value", (String)clonedArguments.toArray(new ArtifactArgument[0])[1].getValue());
        ReferencedPackage_Test.assertTrue((boolean)clonedArguments.toArray(new ArtifactArgument[0])[1].getRequired());
        ReferencedPackage_Test.assertEquals((String)"arg1Name", (String)dataObjectArguments.toArray(new Element[0])[0].getAttribute("name"));
        ReferencedPackage_Test.assertEquals((String)"arg1Value", (String)dataObjectArguments.toArray(new Element[0])[0].getAttribute("value"));
        ReferencedPackage_Test.assertFalse((boolean)Boolean.parseBoolean(dataObjectArguments.toArray(new Element[0])[0].getAttribute("required")));
        ReferencedPackage_Test.assertEquals((String)"arg2Name", (String)dataObjectArguments.toArray(new Element[0])[1].getAttribute("name"));
        ReferencedPackage_Test.assertEquals((String)"arg2Value", (String)dataObjectArguments.toArray(new Element[0])[1].getAttribute("value"));
        ReferencedPackage_Test.assertTrue((boolean)Boolean.parseBoolean(dataObjectArguments.toArray(new Element[0])[1].getAttribute("required")));
    }

    public void testGetReferencedPackageID() {
        ReferencedPackage_Test.assertEquals((String)"referencedPackageID", (String)this.referencedPackage.getReferencedPackageID());
        ReferencedPackage_Test.assertEquals((String)"referencedPackageID", (String)this.clonedReferencedPackage.getReferencedPackageID());
        ReferencedPackage_Test.assertEquals((String)"referencedPackageID", (String)this.element.getAttribute("id"));
    }

    public void testGetOperation() {
        ReferencedPackage_Test.assertEquals((String)"argumentOperation", (String)this.referencedPackage.getOperation());
        ReferencedPackage_Test.assertEquals((String)"argumentOperation", (String)this.clonedReferencedPackage.getOperation());
        ReferencedPackage_Test.assertEquals((String)"argumentOperation", (String)this.element.getAttribute("operation"));
    }

    public void testGetContentReference() {
        ReferencedPackage_Test.assertEquals((String)"referencedPackageContentRef", (String)this.referencedPackage.getContentReference());
        ReferencedPackage_Test.assertEquals((String)"referencedPackageContentRef", (String)this.clonedReferencedPackage.getContentReference());
        ReferencedPackage_Test.assertEquals((String)"referencedPackageContentRef", (String)this.element.getAttribute("contentRef"));
    }

    public void testGetLanguages() {
        Collection<Language> languages = this.referencedPackage.getLanguages();
        Collection<Language> clonedLanguages = this.clonedReferencedPackage.getLanguages();
        Collection<Element> dataObjectLanguages = this.session.getChildren(this.session.getChild(this.element, "Languages"), "Language");
        ReferencedPackage_Test.assertEquals((int)2, (int)languages.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)clonedLanguages.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)dataObjectLanguages.size());
        ReferencedPackage_Test.assertEquals((String)"lang1Type", (String)languages.toArray(new Language[0])[0].getType());
        ReferencedPackage_Test.assertEquals((String)"lang2Type", (String)languages.toArray(new Language[0])[1].getType());
        ReferencedPackage_Test.assertEquals((String)"lang1Type", (String)clonedLanguages.toArray(new Language[0])[0].getType());
        ReferencedPackage_Test.assertEquals((String)"lang2Type", (String)clonedLanguages.toArray(new Language[0])[1].getType());
        ReferencedPackage_Test.assertEquals((String)"lang1Type", (String)dataObjectLanguages.toArray(new Element[0])[0].getAttribute("type"));
        ReferencedPackage_Test.assertEquals((String)"lang2Type", (String)dataObjectLanguages.toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetOutputVariables() {
        Collection<OutputVariable> variables = this.referencedPackage.getOutputVariables();
        Collection<OutputVariable> clonedVariables = this.clonedReferencedPackage.getOutputVariables();
        Collection<Element> dataObjectVariables = this.session.getChildren(this.session.getChild(this.element, "OutputVariables"), "OutputVariable");
        ReferencedPackage_Test.assertEquals((int)2, (int)variables.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)clonedVariables.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)dataObjectVariables.size());
        ReferencedPackage_Test.assertEquals((String)"var1ID", (String)variables.toArray(new OutputVariable[0])[0].getVariableID());
        ReferencedPackage_Test.assertEquals((String)"var2ID", (String)variables.toArray(new OutputVariable[0])[1].getVariableID());
        ReferencedPackage_Test.assertEquals((String)"var1ID", (String)clonedVariables.toArray(new OutputVariable[0])[0].getVariableID());
        ReferencedPackage_Test.assertEquals((String)"var2ID", (String)clonedVariables.toArray(new OutputVariable[0])[1].getVariableID());
        ReferencedPackage_Test.assertEquals((String)"var1ID", (String)dataObjectVariables.toArray(new Element[0])[0].getAttribute("id"));
        ReferencedPackage_Test.assertEquals((String)"var2ID", (String)dataObjectVariables.toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetResultingChangeMaps() {
        Collection<ResultingChangeMap> maps = this.referencedPackage.getResultingChangeMaps();
        Collection<ResultingChangeMap> clonedMaps = this.clonedReferencedPackage.getResultingChangeMaps();
        Collection<Element> dataObjectMaps = this.session.getChildren(this.element, "ResultingChangeMap");
        ReferencedPackage_Test.assertEquals((int)2, (int)maps.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)clonedMaps.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)dataObjectMaps.size());
        ReferencedPackage_Test.assertEquals((String)"change1Ref", (String)maps.toArray(new ResultingChangeMap[0])[0].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"change2Ref", (String)maps.toArray(new ResultingChangeMap[0])[1].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"change1Ref", (String)clonedMaps.toArray(new ResultingChangeMap[0])[0].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"change2Ref", (String)clonedMaps.toArray(new ResultingChangeMap[0])[1].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"change1Ref", (String)dataObjectMaps.toArray(new Element[0])[0].getAttribute("resourceRef"));
        ReferencedPackage_Test.assertEquals((String)"change2Ref", (String)dataObjectMaps.toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetResultingResourceMaps() {
        Collection<ResultingResourceMap> maps = this.referencedPackage.getResultingResourceMaps();
        Collection<ResultingResourceMap> clonedMaps = this.clonedReferencedPackage.getResultingResourceMaps();
        Collection<Element> dataObjectMaps = this.session.getChildren(this.element, "ResultingResourceMap");
        ReferencedPackage_Test.assertEquals((int)2, (int)maps.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)clonedMaps.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)dataObjectMaps.size());
        ReferencedPackage_Test.assertEquals((String)"res1Ref", (String)maps.toArray(new ResultingResourceMap[0])[0].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"res2Ref", (String)maps.toArray(new ResultingResourceMap[0])[1].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"res1Ref", (String)clonedMaps.toArray(new ResultingResourceMap[0])[0].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"res2Ref", (String)clonedMaps.toArray(new ResultingResourceMap[0])[1].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"res1Ref", (String)dataObjectMaps.toArray(new Element[0])[0].getAttribute("resourceRef"));
        ReferencedPackage_Test.assertEquals((String)"res2Ref", (String)dataObjectMaps.toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetRequiredResourceMaps() {
        Collection<ResourceMap> maps = this.referencedPackage.getRequiredResourceMaps();
        Collection<ResourceMap> clonedMaps = this.clonedReferencedPackage.getRequiredResourceMaps();
        Collection<Element> dataObjectMaps = this.session.getChildren(this.element, "RequiredResourceMap");
        ReferencedPackage_Test.assertEquals((int)2, (int)maps.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)clonedMaps.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)dataObjectMaps.size());
        ReferencedPackage_Test.assertEquals((String)"map1Ref", (String)maps.toArray(new ResourceMap[0])[0].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"map2Ref", (String)maps.toArray(new ResourceMap[0])[1].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"map1Ref", (String)clonedMaps.toArray(new ResourceMap[0])[0].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"map2Ref", (String)clonedMaps.toArray(new ResourceMap[0])[1].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"map1Ref", (String)dataObjectMaps.toArray(new Element[0])[0].getAttribute("resourceRef"));
        ReferencedPackage_Test.assertEquals((String)"map2Ref", (String)dataObjectMaps.toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetRequiredFeatures() {
        Collection<ContentSelectionFeature> features = this.referencedPackage.getRequiredFeatures();
        Collection<ContentSelectionFeature> clonedFeatures = this.clonedReferencedPackage.getRequiredFeatures();
        Collection<Element> dataObjectFeatures = this.session.getChildren(this.session.getChild(this.element, "RequiredContentSelection"), "Feature");
        ReferencedPackage_Test.assertEquals((int)2, (int)features.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)clonedFeatures.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)dataObjectFeatures.size());
        ReferencedPackage_Test.assertEquals((String)"feature1", (String)features.toArray(new ContentSelectionFeature[0])[0].getFeature());
        ReferencedPackage_Test.assertEquals((String)"feature2", (String)features.toArray(new ContentSelectionFeature[0])[1].getFeature());
        ReferencedPackage_Test.assertEquals((String)"feature1", (String)clonedFeatures.toArray(new ContentSelectionFeature[0])[0].getFeature());
        ReferencedPackage_Test.assertEquals((String)"feature2", (String)clonedFeatures.toArray(new ContentSelectionFeature[0])[1].getFeature());
        ReferencedPackage_Test.assertEquals((String)"feature1", (String)dataObjectFeatures.toArray(new Element[0])[0].getTextContent());
        ReferencedPackage_Test.assertEquals((String)"feature2", (String)dataObjectFeatures.toArray(new Element[0])[1].getTextContent());
    }

    public void testGetRequiredGroup() {
        ReferencedPackage_Test.assertEquals((String)"groupName", (String)this.referencedPackage.getRequiredGroup());
        ReferencedPackage_Test.assertEquals((String)"groupName", (String)this.clonedReferencedPackage.getRequiredGroup());
        ReferencedPackage_Test.assertEquals((String)"groupName", (String)this.session.getChild(this.session.getChild(((SPIDataObject)((Object)this.referencedPackage)).getElement(), "RequiredContentSelection"), "Group").getTextContent());
    }

    public void testGetRequirements() {
        Collection<Requirement> reqs = this.referencedPackage.getRequirements();
        Collection<Requirement> clonedReqs = this.clonedReferencedPackage.getRequirements();
        Collection<Element> dataObjectReqs = this.session.getChildren(this.session.getChild(this.element, "Requirements"), "Requirement");
        ReferencedPackage_Test.assertEquals((int)2, (int)reqs.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)clonedReqs.size());
        ReferencedPackage_Test.assertEquals((int)2, (int)dataObjectReqs.size());
        ReferencedPackage_Test.assertEquals((String)"req1ID", (String)reqs.toArray(new Requirement[0])[0].getRequirementID());
        ReferencedPackage_Test.assertEquals((String)"req2ID", (String)reqs.toArray(new Requirement[0])[1].getRequirementID());
        ReferencedPackage_Test.assertEquals((String)"req1ID", (String)clonedReqs.toArray(new Requirement[0])[0].getRequirementID());
        ReferencedPackage_Test.assertEquals((String)"req2ID", (String)clonedReqs.toArray(new Requirement[0])[1].getRequirementID());
        ReferencedPackage_Test.assertEquals((String)"req1ID", (String)dataObjectReqs.toArray(new Element[0])[0].getAttribute("id"));
        ReferencedPackage_Test.assertEquals((String)"req2ID", (String)dataObjectReqs.toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetWeight() {
        ReferencedPackage_Test.assertEquals((int)2, (int)this.referencedPackage.getWeight().intValue());
        ReferencedPackage_Test.assertEquals((int)2, (int)this.clonedReferencedPackage.getWeight().intValue());
        ReferencedPackage_Test.assertEquals((int)2, (int)new BigInteger(this.element.getAttribute("weight")).intValue());
    }

    public void testSetArguments() {
        ArtifactArgument arg = new ArtifactArgument("differentArgName", "differentArgValue", new Boolean(true));
        this.referencedPackage.setArguments((Collection<ArtifactArgument>)Arrays.asList(arg));
        Collection<ArtifactArgument> arguments = this.referencedPackage.getArguments();
        Collection<Element> dataObjectArguments = this.session.getChildren(this.session.getChild(this.element, "Arguments"), "Argument");
        ReferencedPackage_Test.assertEquals((int)1, (int)arguments.size());
        ReferencedPackage_Test.assertEquals((int)1, (int)dataObjectArguments.size());
        ReferencedPackage_Test.assertEquals((String)"differentArgName", (String)arguments.toArray(new ArtifactArgument[0])[0].getName());
        ReferencedPackage_Test.assertEquals((String)"differentArgValue", (String)arguments.toArray(new ArtifactArgument[0])[0].getValue());
        ReferencedPackage_Test.assertTrue((boolean)arguments.toArray(new ArtifactArgument[0])[0].getRequired());
        ReferencedPackage_Test.assertEquals((String)"differentArgName", (String)dataObjectArguments.toArray(new Element[0])[0].getAttribute("name"));
        ReferencedPackage_Test.assertEquals((String)"differentArgValue", (String)dataObjectArguments.toArray(new Element[0])[0].getAttribute("value"));
        ReferencedPackage_Test.assertTrue((boolean)Boolean.parseBoolean(dataObjectArguments.toArray(new Element[0])[0].getAttribute("required")));
    }

    public void testSetReferencedPackageID() {
        this.referencedPackage.setReferencedPackageID("differentID");
        ReferencedPackage_Test.assertEquals((String)"differentID", (String)this.referencedPackage.getReferencedPackageID());
        ReferencedPackage_Test.assertEquals((String)"differentID", (String)this.element.getAttribute("id"));
        try {
            this.referencedPackage.setReferencedPackageID(null);
            ReferencedPackage_Test.fail((String)"Null value was set for id");
        }
        catch (Exception exception) {}
    }

    public void testSetOperation() {
        this.referencedPackage.setOperation("differentOperation");
        ReferencedPackage_Test.assertEquals((String)"differentOperation", (String)this.referencedPackage.getOperation());
        ReferencedPackage_Test.assertEquals((String)"differentOperation", (String)this.element.getAttribute("operation"));
    }

    public void testSetContentReference() {
        this.referencedPackage.setContentReference("differentRef");
        ReferencedPackage_Test.assertEquals((String)"differentRef", (String)this.referencedPackage.getContentReference());
        ReferencedPackage_Test.assertEquals((String)"differentRef", (String)this.element.getAttribute("contentRef"));
        try {
            this.referencedPackage.setReferencedPackageID(null);
            ReferencedPackage_Test.fail((String)"Null value was set for contentRef");
        }
        catch (Exception exception) {}
    }

    public void testSetLanguages() {
        Language lang = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("differentType");
        this.referencedPackage.setLanguages((Collection<Language>)Arrays.asList(lang));
        Collection<Language> languages = this.referencedPackage.getLanguages();
        Collection<Element> dataObjectLanguages = this.session.getChildren(this.session.getChild(this.element, "Languages"), "Language");
        ReferencedPackage_Test.assertEquals((int)1, (int)languages.size());
        ReferencedPackage_Test.assertEquals((int)1, (int)dataObjectLanguages.size());
        ReferencedPackage_Test.assertEquals((String)"differentType", (String)languages.toArray(new Language[0])[0].getType());
        ReferencedPackage_Test.assertEquals((String)"differentType", (String)dataObjectLanguages.toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetOutputVariables() {
        OutputVariable var = SPISession.DEFAULT_INSTANCE.createVariableFactory().createOutputVariable("differentID");
        this.referencedPackage.setOutputVariables((Collection<OutputVariable>)Arrays.asList(var));
        Collection<OutputVariable> variables = this.referencedPackage.getOutputVariables();
        Collection<Element> dataObjectVariables = this.session.getChildren(this.session.getChild(this.element, "OutputVariables"), "OutputVariable");
        ReferencedPackage_Test.assertEquals((int)1, (int)variables.size());
        ReferencedPackage_Test.assertEquals((int)1, (int)dataObjectVariables.size());
        ReferencedPackage_Test.assertEquals((String)"differentID", (String)variables.toArray(new OutputVariable[0])[0].getVariableID());
        ReferencedPackage_Test.assertEquals((String)"differentID", (String)dataObjectVariables.toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetRequiredFeatures() {
        ContentSelectionFeature feat = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createContentSelectionFeature("differentFeature");
        this.referencedPackage.setRequiredFeatures((Collection<ContentSelectionFeature>)Arrays.asList(feat));
        Collection<ContentSelectionFeature> features = this.referencedPackage.getRequiredFeatures();
        Collection<Element> dataObjectFeatures = this.session.getChildren(this.session.getChild(this.element, "RequiredContentSelection"), "Feature");
        ReferencedPackage_Test.assertEquals((int)1, (int)features.size());
        ReferencedPackage_Test.assertEquals((int)1, (int)dataObjectFeatures.size());
        ReferencedPackage_Test.assertEquals((String)"differentFeature", (String)features.toArray(new ContentSelectionFeature[0])[0].getFeature());
        ReferencedPackage_Test.assertEquals((String)"differentFeature", (String)dataObjectFeatures.toArray(new Element[0])[0].getTextContent());
    }

    public void testSetRequiredGroup() {
        this.referencedPackage.setRequiredGroup("differentGroup");
        ReferencedPackage_Test.assertEquals((String)"differentGroup", (String)this.referencedPackage.getRequiredGroup());
        ReferencedPackage_Test.assertEquals((String)"differentGroup", (String)this.session.getChildren(this.session.getChildren(this.element, "RequiredContentSelection").toArray(new Element[0])[0], "Group").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetRequirements() {
        Requirement req = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("differentID");
        this.referencedPackage.setRequirements((Collection<Requirement>)Arrays.asList(req));
        Collection<Requirement> reqs = this.referencedPackage.getRequirements();
        Collection<Element> dataObjectReqs = this.session.getChildren(this.session.getChild(this.element, "Requirements"), "Requirement");
        ReferencedPackage_Test.assertEquals((int)1, (int)reqs.size());
        ReferencedPackage_Test.assertEquals((int)1, (int)dataObjectReqs.size());
        ReferencedPackage_Test.assertEquals((String)"differentID", (String)reqs.toArray(new Requirement[0])[0].getRequirementID());
        ReferencedPackage_Test.assertEquals((String)"differentID", (String)dataObjectReqs.toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetResultingChangeMaps() {
        ResultingChangeMap change = SPISession.DEFAULT_INSTANCE.createBaseFactory().createResultingChangeMap("differentRef");
        this.referencedPackage.setResultingChangeMaps((Collection<ResultingChangeMap>)Arrays.asList(change));
        Collection<ResultingChangeMap> maps = this.referencedPackage.getResultingChangeMaps();
        Collection<Element> dataObjectMaps = this.session.getChildren(this.element, "ResultingChangeMap");
        ReferencedPackage_Test.assertEquals((int)1, (int)maps.size());
        ReferencedPackage_Test.assertEquals((int)1, (int)dataObjectMaps.size());
        ReferencedPackage_Test.assertEquals((String)"differentRef", (String)maps.toArray(new ResultingChangeMap[0])[0].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"differentRef", (String)dataObjectMaps.toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetResultingResourceMaps() {
        ResultingResourceMap res = SPISession.DEFAULT_INSTANCE.createBaseFactory().createResultingResourceMap("differentRef");
        this.referencedPackage.setResultingResourceMaps((Collection<ResultingResourceMap>)Arrays.asList(res));
        Collection<ResultingResourceMap> maps = this.referencedPackage.getResultingResourceMaps();
        Collection<Element> dataObjectMaps = this.session.getChildren(this.element, "ResultingResourceMap");
        ReferencedPackage_Test.assertEquals((int)1, (int)maps.size());
        ReferencedPackage_Test.assertEquals((int)1, (int)dataObjectMaps.size());
        ReferencedPackage_Test.assertEquals((String)"differentRef", (String)maps.toArray(new ResultingResourceMap[0])[0].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"differentRef", (String)dataObjectMaps.toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetRequiredResourceMaps() {
        ResourceMap map = SPISession.DEFAULT_INSTANCE.createBaseFactory().createRequiredResourceMap("differentRef");
        this.referencedPackage.setRequiredResourceMaps((Collection<ResourceMap>)Arrays.asList(map));
        Collection<ResourceMap> maps = this.referencedPackage.getRequiredResourceMaps();
        Collection<Element> dataObjectMaps = this.session.getChildren(this.element, "RequiredResourceMap");
        ReferencedPackage_Test.assertEquals((int)1, (int)maps.size());
        ReferencedPackage_Test.assertEquals((int)1, (int)dataObjectMaps.size());
        ReferencedPackage_Test.assertEquals((String)"differentRef", (String)maps.toArray(new ResourceMap[0])[0].getResourceReference());
        ReferencedPackage_Test.assertEquals((String)"differentRef", (String)dataObjectMaps.toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetWeight() {
        this.referencedPackage.setWeight(BigInteger.valueOf(3L));
        ReferencedPackage_Test.assertEquals((int)3, (int)this.referencedPackage.getWeight().intValue());
        ReferencedPackage_Test.assertEquals((int)3, (int)new BigInteger(this.element.getAttribute("weight")).intValue());
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.referencedPackage)).getTranslatableStrings();
        ReferencedPackage_Test.assertTrue((boolean)props.isEmpty());
    }
}

