/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.w3c.dom.Element;

public class ResourceMap_Test
extends TestCase {
    ResourceMap map;
    ResourceMap clonedMap;
    Element element;

    public ResourceMap_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.map = SPISession.DEFAULT_INSTANCE.createBaseFactory().createRequiredResourceMap("resourceRef");
        this.map.setForeignID("foreignID");
        this.clonedMap = (ResourceMap)this.map.clone();
        this.element = ((SPIDataObject)((Object)this.map)).getElement();
    }

    public void testGetForeignID() {
        ResourceMap_Test.assertEquals((String)"foreignID", (String)this.map.getForeignID());
        ResourceMap_Test.assertEquals((String)"foreignID", (String)this.clonedMap.getForeignID());
        ResourceMap_Test.assertEquals((String)"foreignID", (String)this.element.getAttribute("foreignId"));
    }

    public void testGetResourceReference() {
        ResourceMap_Test.assertEquals((String)"resourceRef", (String)this.map.getResourceReference());
        ResourceMap_Test.assertEquals((String)"resourceRef", (String)this.clonedMap.getResourceReference());
        ResourceMap_Test.assertEquals((String)"resourceRef", (String)this.element.getAttribute("resourceRef"));
    }

    public void testSetForeignID() {
        this.map.setForeignID("differentID");
        ResourceMap_Test.assertEquals((String)"differentID", (String)this.map.getForeignID());
        ResourceMap_Test.assertEquals((String)"differentID", (String)this.element.getAttribute("foreignId"));
    }

    public void testSetResourceReference() {
        this.map.setResourceReference("differentRef");
        ResourceMap_Test.assertEquals((String)"differentRef", (String)this.map.getResourceReference());
        ResourceMap_Test.assertEquals((String)"differentRef", (String)this.element.getAttribute("resourceRef"));
        try {
            this.map.setResourceReference(null);
            ResourceMap_Test.fail((String)"ResourceRef was set to null");
        }
        catch (Exception exception) {}
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.map)).getTranslatableStrings();
        ResourceMap_Test.assertEquals((int)0, (int)props.keySet().size());
    }
}

