/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResultingResourceMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;
import org.w3c.dom.Element;

public class ResultingResourceMap_Test
extends TestCase {
    ResultingResourceMap map;
    ResultingResourceMap clonedMap;
    Element element;
    SPISessionImpl session;

    public ResultingResourceMap_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.map = SPISession.DEFAULT_INSTANCE.createBaseFactory().createResultingResourceMap("resourceRef");
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDescription(new TranslatableString("desc", "descKey"));
        this.map.setCondition(condition);
        this.map.setFixNames((Collection<String>)Arrays.asList("fix1", "fix2", "fix3"));
        this.map.setForeignID("mapForeignID");
        this.map.setName("mapName");
        Properties props = new Properties();
        props.setProperty("key1", "value1");
        props.setProperty("key2", "value2");
        this.map.setProperties(props);
        Relationship rel1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createRelationship("map1ResourceRef", "map1Type");
        Relationship rel2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createRelationship("map2ResourceRef", "map2Type");
        this.map.setRelationships((Collection<Relationship>)Arrays.asList(rel1, rel2));
        this.map.setVersion("mapVersion");
        this.clonedMap = (ResultingResourceMap)this.map.clone();
        this.element = ((SPIDataObject)((Object)this.map)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.map)).getTranslatableStrings();
        Properties clonedProps = ((SPIDataObject)((Object)this.clonedMap)).getTranslatableStrings();
        ResultingResourceMap_Test.assertEquals((int)1, (int)props.keySet().size());
        ResultingResourceMap_Test.assertEquals((int)1, (int)clonedProps.keySet().size());
        ResultingResourceMap_Test.assertEquals((Object)"desc", (Object)props.get("descKey"));
        ResultingResourceMap_Test.assertEquals((Object)"desc", (Object)clonedProps.get("descKey"));
    }

    public void testGetFixNames() {
        Collection<String> fixNames = this.map.getFixNames();
        Collection<String> clonedFixNames = this.clonedMap.getFixNames();
        Collection<Element> dataObjectFixNames = this.session.getChildren(this.element, "FixName");
        ResultingResourceMap_Test.assertEquals((int)3, (int)fixNames.size());
        ResultingResourceMap_Test.assertEquals((int)3, (int)clonedFixNames.size());
        ResultingResourceMap_Test.assertEquals((int)3, (int)dataObjectFixNames.size());
        ResultingResourceMap_Test.assertEquals((String)"fix1", (String)fixNames.toArray(new String[0])[0]);
        ResultingResourceMap_Test.assertEquals((String)"fix2", (String)fixNames.toArray(new String[0])[1]);
        ResultingResourceMap_Test.assertEquals((String)"fix3", (String)fixNames.toArray(new String[0])[2]);
        ResultingResourceMap_Test.assertEquals((String)"fix1", (String)clonedFixNames.toArray(new String[0])[0]);
        ResultingResourceMap_Test.assertEquals((String)"fix2", (String)clonedFixNames.toArray(new String[0])[1]);
        ResultingResourceMap_Test.assertEquals((String)"fix3", (String)clonedFixNames.toArray(new String[0])[2]);
        ResultingResourceMap_Test.assertEquals((String)"fix1", (String)dataObjectFixNames.toArray(new Element[0])[0].getTextContent());
        ResultingResourceMap_Test.assertEquals((String)"fix2", (String)dataObjectFixNames.toArray(new Element[0])[1].getTextContent());
        ResultingResourceMap_Test.assertEquals((String)"fix3", (String)dataObjectFixNames.toArray(new Element[0])[2].getTextContent());
    }

    public void testGetName() {
        ResultingResourceMap_Test.assertEquals((String)"mapName", (String)this.map.getName());
        ResultingResourceMap_Test.assertEquals((String)"mapName", (String)this.clonedMap.getName());
        ResultingResourceMap_Test.assertEquals((String)"mapName", (String)this.session.getChildren(this.element, "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetProperties() {
        Properties testProps = this.map.getProperties();
        Properties testclonedProps = this.clonedMap.getProperties();
        Collection<Element> testDataObjectProps = this.session.getChildren(this.element, "Property");
        ResultingResourceMap_Test.assertEquals((Object)"value1", (Object)testProps.get("key1"));
        ResultingResourceMap_Test.assertEquals((Object)"value2", (Object)testProps.get("key2"));
        ResultingResourceMap_Test.assertEquals((Object)"value1", (Object)testclonedProps.get("key1"));
        ResultingResourceMap_Test.assertEquals((Object)"value2", (Object)testclonedProps.get("key2"));
        ResultingResourceMap_Test.assertEquals((int)2, (int)testDataObjectProps.size());
        int i = 0;
        while (i < testDataObjectProps.size()) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            String value = this.session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = this.session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            ResultingResourceMap_Test.assertTrue((String)(String.valueOf(value) + " wasn't found in the properties object"), (boolean)testProps.contains(value));
            ResultingResourceMap_Test.assertTrue((String)(String.valueOf(propertyName) + " wasn't found in the properties object"), (boolean)testProps.containsKey(propertyName));
            ResultingResourceMap_Test.assertEquals((Object)value, (Object)testProps.get(propertyName));
            ++i;
        }
    }

    public void testGetVersion() {
        ResultingResourceMap_Test.assertEquals((String)"mapVersion", (String)this.map.getVersion());
        ResultingResourceMap_Test.assertEquals((String)"mapVersion", (String)this.clonedMap.getVersion());
        ResultingResourceMap_Test.assertEquals((String)"mapVersion", (String)this.session.getChildren(this.element, "Version").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetRelationships() {
        Collection<Relationship> rels = this.map.getRelationships();
        Collection<Relationship> clonedRels = this.clonedMap.getRelationships();
        Collection<Element> dataObjectRels = this.session.getChildren(this.element, "Relationship");
        ResultingResourceMap_Test.assertEquals((int)2, (int)rels.size());
        ResultingResourceMap_Test.assertEquals((int)2, (int)clonedRels.size());
        ResultingResourceMap_Test.assertEquals((int)2, (int)dataObjectRels.size());
        ResultingResourceMap_Test.assertEquals((String)"map1ResourceRef", (String)rels.toArray(new Relationship[0])[0].getRelatedResourceReference());
        ResultingResourceMap_Test.assertEquals((String)"map1Type", (String)rels.toArray(new Relationship[0])[0].getType());
        ResultingResourceMap_Test.assertEquals((String)"map2ResourceRef", (String)rels.toArray(new Relationship[0])[1].getRelatedResourceReference());
        ResultingResourceMap_Test.assertEquals((String)"map2Type", (String)rels.toArray(new Relationship[0])[1].getType());
        ResultingResourceMap_Test.assertEquals((String)"map1ResourceRef", (String)clonedRels.toArray(new Relationship[0])[0].getRelatedResourceReference());
        ResultingResourceMap_Test.assertEquals((String)"map1Type", (String)clonedRels.toArray(new Relationship[0])[0].getType());
        ResultingResourceMap_Test.assertEquals((String)"map2ResourceRef", (String)clonedRels.toArray(new Relationship[0])[1].getRelatedResourceReference());
        ResultingResourceMap_Test.assertEquals((String)"map2Type", (String)clonedRels.toArray(new Relationship[0])[1].getType());
        ResultingResourceMap_Test.assertEquals((String)"map1ResourceRef", (String)dataObjectRels.toArray(new Element[0])[0].getAttribute("relatedResourceRef"));
        ResultingResourceMap_Test.assertEquals((String)"map1Type", (String)dataObjectRels.toArray(new Element[0])[0].getAttribute("type"));
        ResultingResourceMap_Test.assertEquals((String)"map2ResourceRef", (String)dataObjectRels.toArray(new Element[0])[1].getAttribute("relatedResourceRef"));
        ResultingResourceMap_Test.assertEquals((String)"map2Type", (String)dataObjectRels.toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetCondition() {
        Condition mapCondition = this.map.getCondition();
        Condition clonedMapCondition = this.clonedMap.getCondition();
        Element dataObjectMapCondition = this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0];
        ResultingResourceMap_Test.assertEquals((String)"desc", (String)mapCondition.getDescription().getValue());
        ResultingResourceMap_Test.assertEquals((String)"descKey", (String)mapCondition.getDescription().getTranslationKey());
        ResultingResourceMap_Test.assertEquals((String)"desc", (String)clonedMapCondition.getDescription().getValue());
        ResultingResourceMap_Test.assertEquals((String)"descKey", (String)clonedMapCondition.getDescription().getTranslationKey());
        ResultingResourceMap_Test.assertEquals((String)"desc", (String)this.session.getChildren(dataObjectMapCondition, "Description").toArray(new Element[0])[0].getTextContent());
        ResultingResourceMap_Test.assertEquals((String)"descKey", (String)this.session.getChildren(dataObjectMapCondition, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetForeignID() {
        ResultingResourceMap_Test.assertEquals((String)"mapForeignID", (String)this.map.getForeignID());
        ResultingResourceMap_Test.assertEquals((String)"mapForeignID", (String)this.clonedMap.getForeignID());
        ResultingResourceMap_Test.assertEquals((String)"mapForeignID", (String)this.element.getAttribute("foreignId"));
    }

    public void testGetResourceReference() {
        ResultingResourceMap_Test.assertEquals((String)"resourceRef", (String)this.map.getResourceReference());
        ResultingResourceMap_Test.assertEquals((String)"resourceRef", (String)this.clonedMap.getResourceReference());
        ResultingResourceMap_Test.assertEquals((String)"resourceRef", (String)this.element.getAttribute("resourceRef"));
    }

    public void testSetFixNames() {
        this.map.setFixNames((Collection<String>)Arrays.asList("fix4"));
        Collection<String> fixNames = this.map.getFixNames();
        Collection<Element> dataObjectFixNames = this.session.getChildren(this.element, "FixName");
        ResultingResourceMap_Test.assertEquals((int)1, (int)fixNames.size());
        ResultingResourceMap_Test.assertEquals((int)1, (int)dataObjectFixNames.size());
        ResultingResourceMap_Test.assertEquals((String)"fix4", (String)fixNames.toArray(new String[0])[0]);
        ResultingResourceMap_Test.assertEquals((String)"fix4", (String)dataObjectFixNames.toArray(new Element[0])[0].getTextContent());
    }

    public void testSetName() {
        this.map.setName("differentName");
        ResultingResourceMap_Test.assertEquals((String)"differentName", (String)this.map.getName());
        ResultingResourceMap_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.element, "Name").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetProperties() {
        Properties properties = new Properties();
        properties.setProperty("testSetPropertiesKey", "testSetPropertiesValue");
        this.map.setProperties(properties);
        Properties testProps = this.map.getProperties();
        Collection<Element> testDataObjectProps = this.session.getChildren(this.element, "Property");
        ResultingResourceMap_Test.assertEquals((Object)"testSetPropertiesValue", (Object)testProps.get("testSetPropertiesKey"));
        ResultingResourceMap_Test.assertEquals((int)1, (int)testDataObjectProps.size());
        int i = 0;
        while (i < testDataObjectProps.size()) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            String value = this.session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = this.session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            ResultingResourceMap_Test.assertTrue((String)(String.valueOf(value) + " wasn't found in the properties object"), (boolean)testProps.contains(value));
            ResultingResourceMap_Test.assertTrue((String)(String.valueOf(propertyName) + " wasn't found in the properties object"), (boolean)testProps.containsKey(propertyName));
            ResultingResourceMap_Test.assertEquals((Object)value, (Object)testProps.get(propertyName));
            ++i;
        }
    }

    public void testSetVersion() {
        this.map.setVersion("differentVersion");
        ResultingResourceMap_Test.assertEquals((String)"differentVersion", (String)this.map.getVersion());
        ResultingResourceMap_Test.assertEquals((String)"differentVersion", (String)this.session.getChildren(this.element, "Version").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetCondition() {
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDescription(new TranslatableString("differentDesc", "differentDescKey"));
        this.map.setCondition(condition);
        ResultingResourceMap_Test.assertEquals((String)"differentDesc", (String)this.map.getCondition().getDescription().getValue());
        ResultingResourceMap_Test.assertEquals((String)"differentDescKey", (String)this.map.getCondition().getDescription().getTranslationKey());
        Element conditionElement = this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0];
        Element descElement = this.session.getChildren(conditionElement, "Description").toArray(new Element[0])[0];
        ResultingResourceMap_Test.assertEquals((String)"differentDesc", (String)descElement.getTextContent());
        ResultingResourceMap_Test.assertEquals((String)"differentDescKey", (String)descElement.getAttribute("translationKey"));
    }

    public void testSetRelationships() {
        Relationship rel = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createRelationship("differentResourceRef", "differentType");
        this.map.setRelationships((Collection<Relationship>)Arrays.asList(rel));
        Collection<Relationship> rels = this.map.getRelationships();
        Collection<Element> dataObjectRels = this.session.getChildren(this.element, "Relationship");
        ResultingResourceMap_Test.assertEquals((int)1, (int)rels.size());
        ResultingResourceMap_Test.assertEquals((int)1, (int)dataObjectRels.size());
        ResultingResourceMap_Test.assertEquals((String)"differentResourceRef", (String)rels.toArray(new Relationship[0])[0].getRelatedResourceReference());
        ResultingResourceMap_Test.assertEquals((String)"differentType", (String)rels.toArray(new Relationship[0])[0].getType());
        ResultingResourceMap_Test.assertEquals((String)"differentResourceRef", (String)dataObjectRels.toArray(new Element[0])[0].getAttribute("relatedResourceRef"));
        ResultingResourceMap_Test.assertEquals((String)"differentType", (String)dataObjectRels.toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetForeignID() {
        this.map.setForeignID("differentID");
        ResultingResourceMap_Test.assertEquals((String)"differentID", (String)this.map.getForeignID());
        ResultingResourceMap_Test.assertEquals((String)"differentID", (String)this.element.getAttribute("foreignId"));
    }

    public void testSetResourceReference() {
        this.map.setResourceReference("differentRef");
        ResultingResourceMap_Test.assertEquals((String)"differentRef", (String)this.map.getResourceReference());
        ResultingResourceMap_Test.assertEquals((String)"differentRef", (String)this.element.getAttribute("resourceRef"));
        try {
            this.map.setResourceReference(null);
            ResultingResourceMap_Test.fail((String)"ResourceRef was set to null");
        }
        catch (Exception exception) {}
    }
}

