/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.rpm;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.rpm.AllTests;
import org.eclipse.cosmos.me.internal.deployment.sdd.tooling.btg.rpm.RPMReader;

public class RPMReader_Test
extends TestCase {
    public RPMReader_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testValidFileName() throws MalformedURLException, IOException {
        String filename = AllTests.VALID_RPM;
        new RPMReader(filename);
    }

    public void testInvalidFileName() throws MalformedURLException, IOException {
        String filename = String.valueOf(AllTests.ARTIFACTSFILE_LOCATION) + "FileNotHere.rpm";
        try {
            new RPMReader(filename);
            RPMReader_Test.fail((String)"Did not throw FileNotFoundException when invalid file name is given.");
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }

    public void testInvalidFile_NotRPM() throws MalformedURLException, IOException {
        String filename = AllTests.NOT_RPM;
        try {
            RPMReader_Test.fail((String)"Non RPM file not handled yet.");
            new RPMReader(filename);
            RPMReader_Test.fail((String)"Did not throw Exception when non RPM file is given.");
        }
        catch (Exception exception) {}
    }

    public void testInvalidFile_NotVersion3RPM() throws MalformedURLException, IOException {
        RPMReader_Test.fail((String)"None version 3 RPM file not handled yet.");
    }

    public void testInvalidFile_NoExpectedSignature() throws MalformedURLException, IOException {
        RPMReader_Test.fail((String)"No Expected Signature not handled yet.");
    }
}

