/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.AlternativeRequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBaseConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.RequiredBaseConstraintType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.TranslatableStringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlternativeRequiredBaseConstraintType {
    public static AlternativeRequiredBaseConstraint merge(AlternativeRequiredBaseConstraint constraint1, AlternativeRequiredBaseConstraint constraint2) {
        if (constraint1.getPriority() == null && constraint2.getPriority() != null) {
            constraint1.setPriority(constraint2.getPriority());
        } else if (constraint2.getPriority() != null && constraint1.getPriority().compareTo(constraint2.getPriority()) < 0) {
            constraint1.setPriority(constraint2.getPriority());
        }
        constraint1.setDescription(TranslatableStringType.merge(constraint1.getDescription(), constraint2.getDescription()));
        constraint1.setDisplayName(TranslatableStringType.merge(constraint1.getDisplayName(), constraint2.getDisplayName()));
        return constraint1;
    }

    public static Collection<AlternativeRequiredBaseConstraint> merge(Collection<AlternativeRequiredBaseConstraint> alternativeRequiredBaseConstraints1, Collection<AlternativeRequiredBaseConstraint> alternativeRequiredBaseConstraints2) {
        ArrayList<AlternativeRequiredBaseConstraint> alternativeRequiredBaseConstraintsToRemove = new ArrayList<AlternativeRequiredBaseConstraint>();
        for (AlternativeRequiredBaseConstraint alternativeRequiredBaseConstraint1 : alternativeRequiredBaseConstraints1) {
            for (AlternativeRequiredBaseConstraint alternativeRequiredBaseConstraint2 : alternativeRequiredBaseConstraints2) {
                if (alternativeRequiredBaseConstraintsToRemove.contains(alternativeRequiredBaseConstraint2) || !AlternativeRequiredBaseConstraintType.equals(alternativeRequiredBaseConstraint1, alternativeRequiredBaseConstraint2)) continue;
                alternativeRequiredBaseConstraintsToRemove.add(alternativeRequiredBaseConstraint2);
                alternativeRequiredBaseConstraint1 = AlternativeRequiredBaseConstraintType.merge(alternativeRequiredBaseConstraint1, alternativeRequiredBaseConstraint2);
            }
        }
        alternativeRequiredBaseConstraints2.removeAll(alternativeRequiredBaseConstraintsToRemove);
        ArrayList<AlternativeRequiredBaseConstraint> finalAlternativeRequiredBaseConstraints = new ArrayList<AlternativeRequiredBaseConstraint>();
        finalAlternativeRequiredBaseConstraints.addAll(alternativeRequiredBaseConstraints1);
        finalAlternativeRequiredBaseConstraints.addAll(alternativeRequiredBaseConstraints2);
        return finalAlternativeRequiredBaseConstraints;
    }

    public static boolean equals(AlternativeRequiredBaseConstraint constraint1, AlternativeRequiredBaseConstraint constraint2) {
        boolean equals = true;
        Collection requiredBaseConstraints1 = constraint1.getRequiredBaseConstraints();
        Collection requiredBaseConstraints2 = constraint2.getRequiredBaseConstraints();
        Iterator constraintsIter1 = requiredBaseConstraints1.iterator();
        while (constraintsIter1.hasNext() && equals) {
            RequiredBaseConstraint baseConstraint1 = (RequiredBaseConstraint)constraintsIter1.next();
            for (RequiredBaseConstraint baseConstraint2 : requiredBaseConstraints2) {
                if (RequiredBaseConstraintType.equals(baseConstraint1, baseConstraint2)) continue;
                equals = false;
            }
        }
        return equals;
    }
}

