/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Group;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.TranslatableStringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GroupType {
    public static Collection<Group> merge(Collection<Group> groups1, Collection<Group> groups2) {
        ArrayList<Group> groupsToRemove = new ArrayList<Group>();
        for (Group group1 : groups1) {
            for (Group group2 : groups2) {
                if (groupsToRemove.contains(group2) || !GroupType.equals(group1, group2)) continue;
                groupsToRemove.add(group2);
                group1 = GroupType.merge(group1, group2);
            }
        }
        groups2.removeAll(groupsToRemove);
        ArrayList<Group> finalGroups = new ArrayList<Group>();
        finalGroups.addAll(groups1);
        finalGroups.addAll(groups2);
        return finalGroups;
    }

    public static boolean equals(Group group1, Group group2) {
        HashSet features1 = new HashSet(group1.getSelectedFeatures());
        HashSet features2 = new HashSet(group2.getSelectedFeatures());
        return features1.equals(features2);
    }

    public static Group merge(Group group1, Group group2) {
        group1.setDefault(Boolean.valueOf(group1.getDefault() != false || group2.getDefault() != false));
        group1.setDescription(TranslatableStringType.merge(group1.getDescription(), group2.getDescription()));
        group1.setDisplayName(TranslatableStringType.merge(group1.getDisplayName(), group2.getDisplayName()));
        group1.setShortDescription(TranslatableStringType.merge(group1.getShortDescription(), group2.getShortDescription()));
        return group1;
    }
}

