/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingChange;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ArtifactType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.CompletionType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResultingChangeType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResultingResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InstallableUnitType {
    public static InstallableUnit merge(InstallableUnit installableUnit1, InstallableUnit installableUnit2) {
        ResultingResource cfr_ignored_0 = (ResultingResource)installableUnit1.getResultingResources().iterator().next();
        ResultingResource cfr_ignored_1 = (ResultingResource)installableUnit2.getResultingResources().iterator().next();
        Artifact art1 = installableUnit1.getInstallArtifact();
        Artifact art2 = installableUnit2.getInstallArtifact();
        InstallableUnitType.mergeInstallationArtifact(art1, art2, installableUnit1, "", 1);
        art1 = installableUnit1.getUndoArtifact();
        art2 = installableUnit2.getUndoArtifact();
        InstallableUnitType.mergeInstallationArtifact(art1, art2, installableUnit1, "", 2);
        art1 = installableUnit1.getUninstallArtifact();
        art2 = installableUnit2.getUninstallArtifact();
        InstallableUnitType.mergeInstallationArtifact(art1, art2, installableUnit1, "", 3);
        art1 = installableUnit1.getUpdateArtifact();
        art2 = installableUnit2.getUpdateArtifact();
        InstallableUnitType.mergeInstallationArtifact(art1, art2, installableUnit1, "", 4);
        HashSet<Completion> mergedCompletions = new HashSet<Completion>();
        CompletionType.merge(installableUnit1.getInstallableUnitCompletion(), mergedCompletions);
        CompletionType.merge(installableUnit2.getInstallableUnitCompletion(), mergedCompletions);
        installableUnit1.setCompletion(mergedCompletions);
        return installableUnit1;
    }

    private static boolean mergeInstallationArtifact(Artifact art1, Artifact art2, InstallableUnit installableUnit1, String logMsg, int type) {
        Artifact retArt;
        boolean merged = false;
        if (art1 == null && art2 == null) {
            merged = true;
        } else if (ArtifactType.equals(art1, art2) && (retArt = ArtifactType.merge(art1, art2)) != null) {
            switch (type) {
                case 1: {
                    installableUnit1.setInstallArtifact(retArt);
                    merged = true;
                }
                case 2: {
                    installableUnit1.setUndoArtifact(retArt);
                    merged = true;
                }
                case 3: {
                    installableUnit1.setUninstallArtifact(retArt);
                    merged = true;
                }
                case 4: {
                    installableUnit1.setUpdateArtifact(retArt);
                    merged = true;
                }
            }
        }
        return merged;
    }

    private static boolean equals(InstallableUnit unit1, InstallableUnit unit2) {
        ResultingResource r2;
        if (unit1.getResultingResources() == null && unit2.getResultingResources() != null) {
            return false;
        }
        if (unit1.getResultingResources() != null && unit2.getResultingResources() == null) {
            return false;
        }
        ResultingResource r1 = (ResultingResource)unit1.getResultingResources().iterator().next();
        if (!ResultingResourceType.equals(r1, r2 = (ResultingResource)unit2.getResultingResources().iterator().next())) {
            return false;
        }
        if (unit1.getResultingChanges() == null && unit2.getResultingChanges() != null) {
            return false;
        }
        if (unit1.getResultingChanges() != null && unit2.getResultingChanges() == null) {
            return false;
        }
        r1 = (ResultingChange)unit1.getResultingChanges().iterator().next();
        if (!ResultingChangeType.equals((ResultingChange)r1, (ResultingChange)(r2 = (ResultingChange)unit2.getResultingChanges().iterator().next()))) {
            return false;
        }
        return ResourceType.equals(Util.resolveResourceRef(unit1.getTargetResourceReference()), Util.resolveResourceRef(unit2.getTargetResourceReference()));
    }

    public static Collection<InstallableUnit> merge(Collection<InstallableUnit> installableUnits1, Collection<InstallableUnit> installableUnits2) {
        ArrayList<InstallableUnit> installableUnitsToRemove = new ArrayList<InstallableUnit>();
        for (InstallableUnit installableUnit1 : installableUnits1) {
            for (InstallableUnit installableUnit2 : installableUnits2) {
                if (installableUnitsToRemove.contains(installableUnit2) || !InstallableUnitType.equals(installableUnit1, installableUnit2)) continue;
                installableUnitsToRemove.add(installableUnit2);
                installableUnit1 = InstallableUnitType.merge(installableUnit1, installableUnit2);
            }
        }
        installableUnits2.removeAll(installableUnitsToRemove);
        ArrayList<InstallableUnit> finalInstallableUnits = new ArrayList<InstallableUnit>();
        finalInstallableUnits.addAll(installableUnits1);
        finalInstallableUnits.addAll(installableUnits2);
        return finalInstallableUnits;
    }
}

