/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.TranslatableStringType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LanguageType {
    public static Collection<Language> merge(Collection<Language> languages1, Collection<Language> languages2) {
        ArrayList<Language> languagesToRemove = new ArrayList<Language>();
        for (Language language1 : languages1) {
            for (Language language2 : languages2) {
                if (languagesToRemove.contains(language2) || !LanguageType.equals(language1, language2)) continue;
                languagesToRemove.add(language2);
                language1 = LanguageType.merge(language1, language2);
            }
        }
        languages2.removeAll(languagesToRemove);
        ArrayList<Language> finalLanguages = new ArrayList<Language>();
        finalLanguages.addAll(languages1);
        finalLanguages.addAll(languages2);
        return finalLanguages;
    }

    private static Language merge(Language language1, Language language2) {
        language1.setDescription(TranslatableStringType.merge(language1.getDescription(), language2.getDescription()));
        language1.setDisplayName(TranslatableStringType.merge(language1.getDisplayName(), language2.getDisplayName()));
        language1.setShortDescription(TranslatableStringType.merge(language1.getShortDescription(), language2.getShortDescription()));
        return language1;
    }

    public static boolean equals(Language language1, Language language2) {
        return StringType.equals(language1.getType(), language2.getType());
    }
}

