/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ConditionType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.ResourceType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.StringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.TranslatableStringType;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultingResourceType {
    public static Collection<ResultingResource> merge(Collection<ResultingResource> resultingResources1, Collection<ResultingResource> resultingResources2) {
        ArrayList<ResultingResource> resultingResourcesToRemove = new ArrayList<ResultingResource>();
        for (ResultingResource resultingResource1 : resultingResources1) {
            for (ResultingResource resultingResource2 : resultingResources2) {
                if (resultingResourcesToRemove.contains(resultingResource2) || !ResultingResourceType.equals(resultingResource1, resultingResource2)) continue;
                resultingResourcesToRemove.add(resultingResource2);
                resultingResource1 = ResultingResourceType.merge(resultingResource1, resultingResource2);
            }
        }
        resultingResources2.removeAll(resultingResourcesToRemove);
        ArrayList<ResultingResource> finalResultingResources = new ArrayList<ResultingResource>();
        finalResultingResources.addAll(resultingResources1);
        finalResultingResources.addAll(resultingResources2);
        return finalResultingResources;
    }

    public static boolean equals(ResultingResource resource1, ResultingResource resource2) {
        Resource resourceRef2;
        Resource resourceRef1 = Util.resolveResourceRef(resource1.getResourceReference());
        if (!ResourceType.equals(resourceRef1, resourceRef2 = Util.resolveResourceRef(resource2.getResourceReference()))) {
            return false;
        }
        if (resource1.getCondition() == null && resource2.getCondition() != null) {
            return false;
        }
        if (resource1.getCondition() != null && resource2.getCondition() == null) {
            return false;
        }
        if (resource1.getCondition() != null && resource2.getCondition() != null && !ConditionType.equals(resource1.getCondition(), resource2.getCondition())) {
            return false;
        }
        if (resource1.getVersion() == null && resource2.getVersion() != null) {
            return false;
        }
        if (resource1.getVersion() != null && resource2.getVersion() == null) {
            return false;
        }
        return resource1.getVersion() == null || resource2.getVersion() == null || StringType.equals(resource1.getVersion(), resource2.getVersion());
    }

    public static boolean equals(Collection<ResultingResource> resources1, Collection<ResultingResource> resources2) {
        for (ResultingResource resource1 : resources1) {
            boolean match = false;
            Iterator<ResultingResource> iter2 = resources2.iterator();
            while (iter2.hasNext() || !match) {
                ResultingResource resource2 = iter2.next();
                if (!ResultingResourceType.equals(resource1, resource2)) continue;
                match = true;
            }
            if (match) continue;
            return false;
        }
        return true;
    }

    public static ResultingResource merge(ResultingResource resource1, ResultingResource resource2) {
        resource1.setDescription(TranslatableStringType.merge(resource1.getDescription(), resource2.getDescription()));
        resource1.setShortDescription(TranslatableStringType.merge(resource1.getShortDescription(), resource2.getShortDescription()));
        resource1.setName(StringType.merge(resource1.getName(), resource2.getName()));
        resource1.setFixNames(StringType.merge(resource1.getFixNames(), resource2.getFixNames()));
        Properties myProps = resource1.getProperties();
        myProps.putAll((Map<?, ?>)resource2.getProperties());
        resource1.setProperties(myProps);
        return resource1;
    }
}

