/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.validation;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.validation.SDD_DASImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.validation.AllTests;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.validation.exception.XMLValidationException;
import org.w3c.dom.Document;

public class SDD_DASImpl_Test
extends TestCase {
    protected void setUp() throws Exception {
        super.setUp();
        AllTests.copySchemaFiles();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testValidate_SchemaValid() throws FileNotFoundException, IOException, XMLValidationException {
        SDD_DASImpl mySddDas = new SDD_DASImpl();
        Document doc = mySddDas.loadDocument(new FileInputStream(AllTests.VALID_PD));
        SDD_DASImpl_Test.assertEquals((int)mySddDas.validate(doc).size(), (int)0);
    }

    public void testValidate_SchemaInvalid() throws FileNotFoundException, IOException, XMLValidationException {
        SDD_DASImpl mySddDas = new SDD_DASImpl();
        Document doc = mySddDas.loadDocument(new FileInputStream(AllTests.VALID_DD));
        doc.getDocumentElement().removeAttribute("descriptorID");
        SDD_DASImpl_Test.assertFalse((mySddDas.validate(doc).size() == 0 ? 1 : 0) != 0);
    }

    public void testValidate_NonSDD() throws FileNotFoundException, IOException, XMLValidationException {
        SDD_DASImpl mySddDas = new SDD_DASImpl();
        Document doc = mySddDas.loadDocument(new FileInputStream(AllTests.NON_SDD_XML));
        try {
            mySddDas.validate(doc);
            SDD_DASImpl_Test.fail((String)"XML file is not a DD or PD but an IllegalArgumentException was not thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {}
    }
}

