/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Describable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.w3c.dom.Element;

public abstract class DescribableObject
extends SPIDataObject
implements Describable {
    public DescribableObject(Element element, SPISessionImpl session, String sddSchemaType) {
        super(element, session, sddSchemaType);
    }

    public TranslatableString getDescription() {
        TranslatableString ts = null;
        if (this.isSetElement("Description")) {
            ts = new TranslatableString(this.getChild("Description"));
        }
        return ts;
    }

    public TranslatableString getShortDescription() {
        TranslatableString ts = null;
        if (this.isSetElement("ShortDescription")) {
            ts = new TranslatableString(this.getChild("ShortDescription"));
        }
        return ts;
    }

    public void setDescription(TranslatableString description) {
        if (description == null) {
            this.unSetElement("Description");
        } else {
            Element element = this.session.createCommonElement("Description");
            element.setAttribute("translationKey", description.getTranslationKey());
            element.setTextContent(description.getValue());
            this.setContent(element);
        }
    }

    public void setShortDescription(TranslatableString shortDescription) throws InvalidInputException {
        if (shortDescription == null) {
            this.unSetElement("ShortDescription");
        } else {
            Element element = this.session.createCommonElement("ShortDescription");
            element.setAttribute("translationKey", shortDescription.getTranslationKey());
            element.setTextContent(shortDescription.getValue());
            this.setContent(element);
            if (!this.isSetElement("Description") && this.session.isErrorCheckingEnabled()) {
                throw new InvalidInputException(1, 4);
            }
        }
    }

    public String toString() {
        String temp = new String();
        Element descriptionElement = this.getChild("Description");
        Element shortDescriptionElement = this.getChild("ShortDescription");
        if (descriptionElement != null) {
            temp = String.valueOf(temp) + "Description - \"" + descriptionElement.getTextContent() + "\"\n";
            temp = shortDescriptionElement != null ? String.valueOf(temp) + "Short Description - \"" + shortDescriptionElement.getTextContent() + "\"\n" : String.valueOf(temp) + "Short Description - not defined\n";
        } else {
            temp = String.valueOf(temp) + "No description defined\n";
        }
        return temp;
    }
}

