/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescriptorImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.PackageContentImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.PackageIdentityImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.xmldsig.SignatureImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageContent;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.xmldsig.Signature;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PackageDescriptorImpl
extends DescriptorImpl
implements PackageDescriptor {
    private static final String PACKAGE_DESCRIPTOR_TYPE = "sdd-pd:PackageDescriptorType";
    private static final String CONTENTS_TYPE = "sdd-pd:ContentsType";

    public PackageDescriptorImpl(Document doc, SPISessionImpl session) {
        super(doc, session, PACKAGE_DESCRIPTOR_TYPE);
    }

    @Override
    public Collection<PackageContent> getPackageContents() {
        ArrayList<PackageContentImpl> packageContents = null;
        if (this.isSetElement("Contents")) {
            packageContents = new ArrayList<PackageContentImpl>();
            Collection<Element> contentElements = this.session.getChildren(this.getChild("Contents"), "Content");
            for (Element contentElement : contentElements) {
                packageContents.add(new PackageContentImpl(contentElement, this.session));
            }
        }
        return packageContents;
    }

    @Override
    public Signature getSignature() {
        if (this.isSetElement("Signature")) {
            return new SignatureImpl(this.getChild("Signature"), this.session);
        }
        return null;
    }

    @Override
    public void setPackageContents(Collection<PackageContent> aPackageContents) {
        this.session.testParameter(aPackageContents, 1, null);
        if (aPackageContents != null) {
            Element contentsElement = this.session.createPackageElement("Contents");
            for (PackageContent packageContent : aPackageContents) {
                Element contentElement = ((SPIDataObject)((Object)packageContent)).getElement();
                this.session.insertNode((Node)contentsElement, (Node)contentElement, CONTENTS_TYPE);
            }
            this.setContent(contentsElement);
        } else {
            this.unSetElement("Contents");
        }
    }

    @Override
    public PackageIdentity getPackageIdentity() {
        if (this.isSetElement("PackageIdentity")) {
            return new PackageIdentityImpl(this.getChild("PackageIdentity"), this.session);
        }
        return null;
    }

    @Override
    public void setPackageIdentity(PackageIdentity packageIdentity) {
        this.session.testParameter(packageIdentity, 1, null);
        if (packageIdentity != null) {
            this.setContent((SPIDataObject)((Object)packageIdentity));
        } else {
            this.unSetElement("PackageIdentity");
        }
    }

    @Override
    public void setSignature(Signature signature) {
        if (signature == null) {
            this.unSetElement("Signature");
        } else {
            this.setContent((SPIDataObject)((Object)signature));
        }
    }

    @Override
    public String toString() {
        String description = "Package Descriptor\n------------------\n" + super.toString() + "\n";
        description = this.isSetElement("PackageIdentity") ? String.valueOf(description) + this.getPackageIdentity() + "\n" : String.valueOf(description) + "Package Identity - not defined\n\n";
        int i = 0;
        for (PackageContent packageContent : this.getPackageContents()) {
            description = String.valueOf(description) + "Content " + ++i + ": " + packageContent;
        }
        return description;
    }

    @Override
    public Object clone() {
        return new PackageDescriptorImpl((Document)this.document.cloneNode(true), this.session);
    }
}

