/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.AlternativeConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionalResourceConstraintImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.AlternativeCondition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.ConditionalResourceConstraint;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConditionImpl
extends NameableObject
implements Condition {
    private static final String CONDITION_TYPE = "sdd-dd:ConditionType";

    public ConditionImpl(Element data, SPISessionImpl session) {
        super(data, session, CONDITION_TYPE);
    }

    @Override
    public Collection<AlternativeCondition> getAlternativeConditions() {
        Collection<Element> alternativeConditionList = this.getChildren("Alternative");
        ArrayList<AlternativeCondition> alternativeConditions = new ArrayList<AlternativeCondition>();
        for (Element element : alternativeConditionList) {
            AlternativeConditionImpl alternativeCondition = new AlternativeConditionImpl(element, this.session);
            alternativeConditions.add(alternativeCondition);
        }
        return alternativeConditions;
    }

    @Override
    public Collection<ConditionalResourceConstraint> getConditionalResourceConstraints() {
        Collection<Element> conditionalResourceConstraintList = this.getChildren("ResourceConstraint");
        ArrayList<ConditionalResourceConstraint> conditionalResourceConstraints = new ArrayList<ConditionalResourceConstraint>();
        for (Element element : conditionalResourceConstraintList) {
            ConditionalResourceConstraintImpl crc = new ConditionalResourceConstraintImpl(element, this.session);
            conditionalResourceConstraints.add(crc);
        }
        return conditionalResourceConstraints;
    }

    @Override
    public Collection<String> getOperations() {
        String operationList = this.getAttribute("operation");
        ArrayList<String> operations = new ArrayList<String>();
        if (operationList != null && operationList.length() > 0) {
            String[] tokens;
            String[] stringArray = tokens = operationList.split(" ");
            int n = tokens.length;
            int n2 = 0;
            while (n2 < n) {
                String token = stringArray[n2];
                operations.add(token);
                ++n2;
            }
        }
        return operations;
    }

    @Override
    public void setAlternativeConditions(Collection<AlternativeCondition> alternativeConditions) {
        this.removeContent(this.getChildren("Alternative", false));
        this.addContent(alternativeConditions);
    }

    @Override
    public void setConditionalResourceConstraints(Collection<ConditionalResourceConstraint> crc) {
        this.removeContent(this.getChildren("ResourceConstraint", false));
        this.addContent(crc);
    }

    @Override
    public void setOperations(Collection<String> operations) {
        if (operations == null || operations.size() == 0) {
            this.unSetAttribute("operation");
        } else {
            String operationString = "";
            for (String operation : operations) {
                operationString = String.valueOf(operationString) + operation + " ";
            }
            operationString = operationString.substring(0, operationString.length() - 1);
            this.setAttribute("operation", operationString);
        }
    }

    @Override
    public Object clone() {
        return new ConditionImpl((Element)this.getElement().cloneNode(true), this.session);
    }
}

