/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompletionImpl
extends NameableObject
implements Completion {
    private static final String COMPLETION_TYPE = "sdd-dd:CompletionType";

    public CompletionImpl(Element data, SPISessionImpl session) {
        super(data, session, COMPLETION_TYPE);
    }

    @Override
    public Condition getCondition() {
        ConditionImpl c = null;
        if (this.isSetElement("Condition")) {
            c = new ConditionImpl(this.getChild("Condition"), this.session);
        }
        return c;
    }

    @Override
    public Collection<String> getCompletionOperations() {
        ArrayList<String> operations = new ArrayList<String>();
        if (this.isSetAttribute("operation")) {
            StringTokenizer operationTokenizer = new StringTokenizer(this.getAttribute("operation"));
            while (operationTokenizer.hasMoreTokens()) {
                operations.add(operationTokenizer.nextToken());
            }
        }
        return operations;
    }

    @Override
    public String getCompletionResourceReference() {
        return this.getAttribute("resourceRef");
    }

    @Override
    public String getCompletionType() {
        return this.getAttribute("type");
    }

    @Override
    public void setCompletionOperations(Collection<String> operations) {
        if (operations == null || operations.isEmpty()) {
            this.unSetAttribute("operation");
        } else {
            String operationString = "";
            for (String operation : operations) {
                operationString = String.valueOf(operationString) + operation + " ";
            }
            this.setAttribute("operation", operationString.trim());
        }
    }

    @Override
    public void setCompletionResourceReference(String completionResourceReference) {
        this.session.testParameter(completionResourceReference, 1, null);
        this.setAttribute("resourceRef", completionResourceReference);
    }

    @Override
    public void setCompletionType(String completionType) {
        this.session.testParameter(completionType, 1, null);
        this.setAttribute("type", completionType);
    }

    @Override
    public void setCondition(Condition condition) {
        if (condition == null) {
            this.unSetElement("Condition");
        } else {
            this.setContent((SPIDataObject)((Object)condition));
        }
    }

    @Override
    public Object clone() {
        Element copy = (Element)this.getElement().cloneNode(true);
        CompletionImpl duplicate = new CompletionImpl(copy, this.session);
        return duplicate;
    }
}

