/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.CompletionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.InstallUnitImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit.LanguageImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requiredbase.RequiredBaseImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalizationUnitImpl
extends InstallUnitImpl
implements LocalizationUnit {
    private static final String LOCALIZATION_UNIT_TYPE = "sdd-dd:LocalizationUnitType";
    private static final String LANGUAGES_TYPE = "sdd-dd:LanguagesType";

    public LocalizationUnitImpl(Element data, SPISessionImpl session) {
        super(data, session, LOCALIZATION_UNIT_TYPE);
    }

    @Override
    public Collection<Completion> getCompletion() {
        ArrayList<Completion> completions = new ArrayList<Completion>();
        Collection<Element> completionElements = this.getChildren("Completion");
        for (Element completionElement : completionElements) {
            completions.add(new CompletionImpl(completionElement, this.session));
        }
        return completions;
    }

    @Override
    public RequiredBase getLocalizationBase() {
        RequiredBaseImpl localizationBase = null;
        if (this.isSetElement("LocalizationBase")) {
            localizationBase = new RequiredBaseImpl(this.getChild("LocalizationBase"), this.session);
        }
        return localizationBase;
    }

    @Override
    public Collection<Language> getLanguages() {
        ArrayList<Language> languages = new ArrayList<Language>();
        if (this.isSetElement("Languages")) {
            Element languagesElement = this.getChild("Languages");
            Collection<Element> languageElements = this.session.getChildren(languagesElement, "Language");
            for (Element element : languageElements) {
                languages.add(new LanguageImpl(element, this.session));
            }
        }
        return languages;
    }

    @Override
    public void setCompletion(Collection<Completion> configurationUnitCompletion) {
        if (configurationUnitCompletion == null) {
            this.unSetElement("Completion");
        } else {
            this.removeContent(this.getChildren("Completion", false));
            this.addContent(configurationUnitCompletion);
        }
    }

    @Override
    public void setLocalizationBase(RequiredBase localizationBase) {
        this.session.testParameter(localizationBase, 1, null);
        if (localizationBase == null) {
            this.unSetElement("RequiredBase");
        } else {
            this.setContent((SPIDataObject)((Object)localizationBase));
        }
    }

    @Override
    public void setLanguages(Collection<Language> languages) {
        if (languages == null) {
            this.unSetElement("Languages");
        } else {
            Element languagesElement = this.session.createDeploymentElement("Languages");
            for (Language language : languages) {
                this.session.insertNode((Node)languagesElement, (SPIDataObject)((Object)language), LANGUAGES_TYPE);
            }
            this.setContent(languagesElement);
        }
    }
}

