/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.contentunit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Properties;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.condition.ConditionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.util.ConversionUtil;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResultingResourceImpl
extends DescribableObject
implements ResultingResource {
    private static final String RESULTING_RESOURCE_TYPE = "sdd-dd:ResultingResourceType";
    private static final String RESULTING_PROPERTY_TYPE = "sdd-dd:ResultingPropertyType";

    public ResultingResourceImpl(Element data, SPISessionImpl session) {
        super(data, session, RESULTING_RESOURCE_TYPE);
    }

    @Override
    public String getName() {
        String name = null;
        if (this.isSetElement("Name")) {
            name = this.getChild("Name").getTextContent();
        }
        return name;
    }

    @Override
    public String getResourceReference() {
        return this.getAttribute("resourceRef");
    }

    @Override
    public Collection<String> getFixNames() {
        ArrayList<String> fixNames = new ArrayList<String>();
        if (this.isSetElement("FixName")) {
            Collection<Element> fixNameElements = this.getChildren("FixName");
            for (Element fixNameElement : fixNameElements) {
                fixNames.add(fixNameElement.getTextContent());
            }
        }
        return fixNames;
    }

    @Override
    public Properties getProperties() {
        Collection<Element> propertyElements = this.getChildren("Property");
        return ConversionUtil.getPropertiesFromPropertyElementList(propertyElements);
    }

    @Override
    public String getVersion() {
        String version = null;
        if (this.isSetElement("Version")) {
            version = this.getChild("Version").getTextContent();
        }
        return version;
    }

    @Override
    public void setName(String name) {
        if (name == null) {
            this.unSetElement("Name");
        } else {
            Element nameElement = this.session.createDeploymentElement("Name");
            nameElement.setTextContent(name);
            this.setContent(nameElement);
        }
    }

    @Override
    public void setResourceReference(String resourceReference) {
        this.session.testParameter(resourceReference, 1, null);
        this.setAttribute("resourceRef", resourceReference);
    }

    @Override
    public void setFixNames(Collection<String> fixNames) {
        if (fixNames == null) {
            this.unSetElement("FixName");
        } else {
            this.removeContent(this.getChildren("FixName", false));
            ArrayList<Element> fixNameElements = new ArrayList<Element>();
            for (String fixName : fixNames) {
                Element fixNameElement = this.session.createDeploymentElement("FixName");
                fixNameElement.setTextContent(fixName);
                fixNameElements.add(fixNameElement);
            }
            this.addContent(fixNameElements);
        }
    }

    @Override
    public void setProperties(Properties newResultingResourceProperties) {
        if (newResultingResourceProperties != null) {
            ArrayList<Element> properties = new ArrayList<Element>();
            this.removeContent(this.getChildren("Property", false));
            Enumeration<Object> e = newResultingResourceProperties.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                String value = newResultingResourceProperties.getProperty(key);
                Element propertyElement = this.session.createDeploymentElement("Property");
                Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
                Element valueElement = this.session.createDeploymentElement("Value");
                propertyNameElement.setTextContent(key);
                valueElement.setTextContent(value);
                this.session.insertNode((Node)propertyElement, (Node)propertyNameElement, RESULTING_PROPERTY_TYPE);
                this.session.insertNode((Node)propertyElement, (Node)valueElement, RESULTING_PROPERTY_TYPE);
                properties.add(propertyElement);
            }
            this.addContent(properties);
        } else {
            this.unSetElement("Property");
        }
    }

    @Override
    public void setVersion(String version) {
        if (version == null) {
            this.unSetElement("Version");
        } else {
            Element versionElement = this.session.createDeploymentElement("Version");
            versionElement.setTextContent(version);
            this.setContent(versionElement);
        }
    }

    @Override
    public String toString() {
        String resultingResourceContents = String.valueOf(super.toString()) + "Resource Reference: \"" + this.getResourceReference() + "\"\n";
        String version = this.getVersion();
        if (version != null) {
            resultingResourceContents = String.valueOf(resultingResourceContents) + "Version: " + version + "\n";
        }
        Properties resultingResourceProperties = this.getProperties();
        Enumeration<Object> e = resultingResourceProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            resultingResourceContents = String.valueOf(resultingResourceContents) + " Resulting Resource Property - Key = \"" + key + "\" , value = \"" + resultingResourceProperties.getProperty(key) + "\"\n";
        }
        return resultingResourceContents;
    }

    @Override
    public Object clone() {
        return new ResultingResourceImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    @Override
    public Condition getCondition() {
        ConditionImpl condition = null;
        if (this.isSetElement("Condition")) {
            condition = new ConditionImpl(this.getChild("Condition"), this.session);
        }
        return condition;
    }

    @Override
    public void setCondition(Condition condition) {
        if (condition == null) {
            this.unSetElement("Condition");
        } else {
            this.setContent((SPIDataObject)((Object)condition));
        }
    }
}

