/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.DescribableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.CapacityValueImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.CapacityConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.CapacityValue;
import org.w3c.dom.Element;

public class CapacityConstraintImpl
extends DescribableObject
implements CapacityConstraint {
    private static final String CAPACITY_CONSTRAINT_TYPE = "sdd-dd:CapacityConstraintType";

    public CapacityConstraintImpl(Element data, SPISessionImpl session) {
        super(data, session, CAPACITY_CONSTRAINT_TYPE);
    }

    public String getMaximum() {
        return this.getValue().getMaximum();
    }

    public String getMinimum() {
        return this.getValue().getMinimum();
    }

    public String getRecommendedMaximum() {
        return this.getValue().getRecommendedMaximum();
    }

    public String getRecommendedMinimum() {
        return this.getValue().getRecommendedMinimum();
    }

    public String getUnitOfMeasure() {
        return this.getValue().getUnitOfMeasure();
    }

    private CapacityValue getValue() {
        CapacityValueImpl cv = null;
        if (this.isSetElement("Value")) {
            cv = new CapacityValueImpl(this.getChild("Value", false), this.session);
        } else {
            cv = new CapacityValueImpl(this.session.createDeploymentElement("Value"), this.session);
            this.setContent(cv);
        }
        return cv;
    }

    public String getPropertyName() {
        return this.isSetElement("PropertyName") ? this.getChild("PropertyName").getTextContent() : null;
    }

    public void setPropertyName(String propertyName) {
        this.session.testParameter(propertyName, 1, null);
        if (propertyName == null) {
            this.unSetElement("PropertyName");
        } else {
            Element nameElement = this.session.createDeploymentElement("PropertyName");
            nameElement.setTextContent(propertyName);
            this.setContent(nameElement);
        }
    }

    public void setMaximum(String maximum) {
        this.getValue().setMaximum(maximum);
    }

    public void setMinimum(String minimum) {
        this.getValue().setMinimum(minimum);
    }

    public void setRecommendedMaximum(String recommendedMaximum) {
        this.getValue().setRecommendedMaximum(recommendedMaximum);
    }

    public void setRecommendedMinimum(String recommendedMinimum) {
        this.getValue().setRecommendedMinimum(recommendedMinimum);
    }

    public void setUnitOfMeasure(String unitOfMeasure) {
        this.getValue().setUnitOfMeasure(unitOfMeasure);
    }

    public String toString() {
        String capacityConstraintContents = new String("Property name: " + this.getPropertyName());
        CapacityValue cv = this.getValue();
        if (((SPIDataObject)((Object)cv)).isSetElement("Maximum")) {
            capacityConstraintContents = String.valueOf(capacityConstraintContents) + ", Maximum: " + cv.getMaximum();
        }
        if (((SPIDataObject)((Object)cv)).isSetElement("Minimum")) {
            capacityConstraintContents = String.valueOf(capacityConstraintContents) + ", Minimum: " + cv.getMinimum();
        }
        if (((SPIDataObject)((Object)cv)).isSetElement("MaximumRecommended")) {
            capacityConstraintContents = String.valueOf(capacityConstraintContents) + ", MaximumRecommended: " + cv.getRecommendedMaximum();
        }
        if (((SPIDataObject)((Object)cv)).isSetElement("MinimumRecommended")) {
            capacityConstraintContents = String.valueOf(capacityConstraintContents) + ", MinimumRecommended: " + cv.getRecommendedMinimum();
        }
        if (((SPIDataObject)((Object)cv)).isSetElement("unit")) {
            capacityConstraintContents = String.valueOf(capacityConstraintContents) + ", unit: " + cv.getUnitOfMeasure();
        }
        return String.valueOf(capacityConstraintContents) + "\n" + super.toString();
    }

    public Object clone() {
        Element copy = (Element)this.getElement().cloneNode(true);
        CapacityConstraintImpl duplicate = new CapacityConstraintImpl(copy, this.session);
        return duplicate;
    }
}

