/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.Collection;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.AlternativeRequirementImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.CapacityConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.ConsumptionConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.InternalDependencyImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.PropertyConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RelationshipConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementResourceConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.UniquenessConstraintImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.VersionConstraintImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.exception.InvalidInputException;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.AlternativeRequirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.CapacityConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.ConsumptionConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.InternalDependency;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.PropertyConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RelationshipConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementFactory;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.UniquenessConstraint;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.VersionConstraint;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementFactoryImpl
implements RequirementFactory {
    private SPISessionImpl session;
    private static final String CAPACITY_CONSTRAINT_TYPE = "sdd-dd:CapacityConstraintType";
    private static final String CONSUMPTION_CONSTRAINT_TYPE = "sdd-dd:ConsumptionConstraintType";
    private static final String PROPERTY_CONSTRAINT_TYPE = "sdd-dd:PropertyConstraintType";
    private static final String PROPERTY_VALUE_LIST_TYPE = "sdd-dd:PropertyValueListType";

    public RequirementFactoryImpl(SPISessionImpl session) {
        this.session = session;
    }

    @Override
    public AlternativeRequirement createAlternativeRequirement(String alternativeRequirementID) {
        this.session.testParameter(alternativeRequirementID, 1, null);
        Element alternativeRequirementElement = this.session.createDeploymentElement("Alternative");
        alternativeRequirementElement.setAttribute("id", alternativeRequirementID);
        return new AlternativeRequirementImpl(alternativeRequirementElement, this.session);
    }

    @Override
    public CapacityConstraint createCapacityConstraint(String propertyName) {
        this.session.testParameter(propertyName, 1, null);
        Element capacityConstraintElement = this.session.createDeploymentElement("CapacityConstraint");
        Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
        propertyNameElement.setTextContent(propertyName);
        this.session.insertNode((Node)capacityConstraintElement, (Node)propertyNameElement, CAPACITY_CONSTRAINT_TYPE);
        return new CapacityConstraintImpl(capacityConstraintElement, this.session);
    }

    @Override
    public ConsumptionConstraint createConsumptionConstraint(String propertyName) {
        this.session.testParameter(propertyName, 1, null);
        Element consumptionConstraintElement = this.session.createDeploymentElement("ConsumptionConstraint");
        Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
        propertyNameElement.setTextContent(propertyName);
        this.session.insertNode((Node)consumptionConstraintElement, (Node)propertyNameElement, CONSUMPTION_CONSTRAINT_TYPE);
        return new ConsumptionConstraintImpl(consumptionConstraintElement, this.session);
    }

    @Override
    public PropertyConstraint createPropertyConstraintMultiValue(String propertyName, Collection<String> propertyValues) {
        this.session.testParameter(propertyName, 1, null);
        this.session.testParameter(propertyValues, 2, null);
        Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
        propertyNameElement.setTextContent(propertyName);
        Element propertyValueListElement = this.session.createDeploymentElement("ListOfValues");
        for (String propertyValue : propertyValues) {
            Element valueElement = this.session.createDeploymentElement("Value");
            valueElement.setTextContent(propertyValue);
            this.session.insertNode((Node)propertyValueListElement, (Node)valueElement, PROPERTY_VALUE_LIST_TYPE);
        }
        Element pcElement = this.session.createDeploymentElement("PropertyConstraint");
        this.session.insertNode((Node)pcElement, (Node)propertyNameElement, PROPERTY_CONSTRAINT_TYPE);
        this.session.insertNode((Node)pcElement, (Node)propertyValueListElement, PROPERTY_CONSTRAINT_TYPE);
        return new PropertyConstraintImpl(pcElement, this.session);
    }

    @Override
    public PropertyConstraint createPropertyConstraintSingleValue(String propertyName, String value) {
        this.session.testParameter(propertyName, 1, null);
        this.session.testParameter(value, 2, null);
        Element propertyNameElement = this.session.createDeploymentElement("PropertyName");
        propertyNameElement.setTextContent(propertyName);
        Element valueElement = this.session.createDeploymentElement("Value");
        valueElement.setTextContent(value);
        Element pcElement = this.session.createDeploymentElement("PropertyConstraint");
        this.session.insertNode((Node)pcElement, (Node)propertyNameElement, PROPERTY_CONSTRAINT_TYPE);
        this.session.insertNode((Node)pcElement, (Node)valueElement, PROPERTY_CONSTRAINT_TYPE);
        return new PropertyConstraintImpl(pcElement, this.session);
    }

    @Override
    public Requirement createRequirement(String requirementID) {
        this.session.testParameter(requirementID, 1, null);
        Element requirementElement = this.session.createDeploymentElement("Requirement");
        requirementElement.setAttribute("id", requirementID);
        return new RequirementImpl(requirementElement, this.session);
    }

    @Override
    public RequirementResourceConstraint createRequirementResourceConstraint(String resourceConstraintID, String resourceReference) {
        this.session.testParameter(resourceConstraintID, 1, null);
        this.session.testParameter(resourceReference, 2, null);
        Element rrcElement = this.session.createDeploymentElement("ResourceConstraint");
        rrcElement.setAttribute("id", resourceConstraintID);
        rrcElement.setAttribute("resourceRef", resourceReference);
        return new RequirementResourceConstraintImpl(rrcElement, this.session);
    }

    @Override
    public VersionConstraint createVersionConstraint() {
        Element vcElement = this.session.createDeploymentElement("VersionConstraint");
        return new VersionConstraintImpl(vcElement, this.session);
    }

    @Override
    public InternalDependency createInternalDependency(String contentRef) throws InvalidInputException {
        this.session.testParameter(contentRef, 1, null);
        Element internalDepElement = this.session.createDeploymentElement("InternalDependency");
        internalDepElement.setAttribute("contentElementRef", contentRef);
        return new InternalDependencyImpl(internalDepElement, this.session);
    }

    @Override
    public RelationshipConstraint createRelationshipConstraint(String type) throws InvalidInputException {
        this.session.testParameter(type, 1, null);
        Element rcElement = this.session.createDeploymentElement("RelationshipConstraint");
        rcElement.setAttribute("type", type);
        return new RelationshipConstraintImpl(rcElement, this.session);
    }

    @Override
    public UniquenessConstraint createUniquenessConstraint(String distinctResourceRef) throws InvalidInputException {
        this.session.testParameter(distinctResourceRef, 1, null);
        Element ucElement = this.session.createDeploymentElement("UniquenessConstraint");
        ucElement.setAttribute("distinctResourceRef", distinctResourceRef);
        return new UniquenessConstraintImpl(ucElement, this.session);
    }
}

