/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement;

import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.NameableObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.AlternativeRequirementImpl;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.requirement.RequirementResourceConstraintImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.AlternativeRequirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RequirementResourceConstraint;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequirementImpl
extends NameableObject
implements Requirement {
    private static final String REQUIREMENT_TYPE = "sdd-dd:RequirementType";

    public RequirementImpl(Element data, SPISessionImpl session) {
        super(data, session, REQUIREMENT_TYPE);
    }

    @Override
    public Collection<AlternativeRequirement> getAlternativeRequirements() {
        Collection<Element> arElements = this.getChildren("Alternative");
        ArrayList<AlternativeRequirement> alternatives = new ArrayList<AlternativeRequirement>();
        for (Element element : arElements) {
            AlternativeRequirementImpl alternative = new AlternativeRequirementImpl(element, this.session);
            alternatives.add(alternative);
        }
        return alternatives;
    }

    @Override
    public Collection<String> getOperations() {
        ArrayList<String> operations = new ArrayList<String>();
        if (this.isSetAttribute("operation")) {
            String op = this.getAttribute("operation");
            StringTokenizer st = new StringTokenizer(op);
            while (st.hasMoreTokens()) {
                operations.add(st.nextToken());
            }
        }
        return operations;
    }

    @Override
    public String getRequirementID() {
        return this.getAttribute("id");
    }

    @Override
    public Collection<RequirementResourceConstraint> getResourceConstraints() {
        Collection<Element> rrcElements = this.getChildren("ResourceConstraint");
        ArrayList<RequirementResourceConstraint> rrcs = new ArrayList<RequirementResourceConstraint>();
        for (Element element : rrcElements) {
            RequirementResourceConstraintImpl rrc = new RequirementResourceConstraintImpl(element, this.session);
            rrcs.add(rrc);
        }
        return rrcs;
    }

    @Override
    public void setOperations(Collection<String> operations) {
        if (operations == null || operations.isEmpty()) {
            this.unSetAttribute("operation");
        } else {
            String op = "";
            for (String s : operations) {
                op = String.valueOf(op) + s + " ";
            }
            this.setAttribute("operation", op.substring(0, op.length() - 1));
        }
    }

    @Override
    public void setRequirementID(String requirementID) {
        this.session.testParameter(requirementID, 1, null);
        this.setAttribute("id", requirementID);
    }

    @Override
    public void setResourceConstraints(Collection<RequirementResourceConstraint> newResourceConstraints) {
        if (newResourceConstraints != null && !newResourceConstraints.isEmpty()) {
            this.removeContent(this.getChildren("ResourceConstraint", false));
            this.addContent(newResourceConstraints);
        } else {
            this.unSetElement("ResourceConstraint");
        }
    }

    @Override
    public void setAlternativeRequirements(Collection<AlternativeRequirement> newAlternativeRequirements) {
        if (newAlternativeRequirements != null && !newAlternativeRequirements.isEmpty()) {
            this.removeContent(this.getChildren("Alternative", false));
            this.addContent(newAlternativeRequirements);
        } else {
            this.unSetElement("Alternative");
        }
    }

    @Override
    public Object clone() {
        return new RequirementImpl((Element)this.getElement().cloneNode(true), this.session);
    }

    @Override
    public String toString() {
        String requirementContents = new String("Req ID: " + this.getRequirementID());
        if (this.isSetAttribute("operation")) {
            requirementContents = String.valueOf(requirementContents) + " , Operation: " + this.getAttribute("operation");
        }
        return requirementContents;
    }
}

