/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Arrays;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Identity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ReferencedPackage;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.artifact.Artifact;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Completion;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeLocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Language;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requiredbase.RequiredBase;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.Requirement;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.BooleanParameter;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ConditionalDerivedVariableExpression;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.DerivedVariable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ParameterGroup;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.variable.ResourceProperty;
import org.w3c.dom.Element;

public class CompositeLocalizationUnit_Test
extends TestCase {
    CompositeLocalizationUnit unit;
    CompositeLocalizationUnit clonedUnit;
    Element element;
    SPISessionImpl session;

    public CompositeLocalizationUnit_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        Artifact art1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art1.setContentReference("art1ContentRef");
        LocalizationUnit lu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu1ID", "lu1ResourceRef", art1, 0);
        Artifact art2 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art2.setContentReference("art2ContentRef");
        LocalizationUnit lu2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu2ID", "lu2ResourceRef", art2, 0);
        this.unit = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithLocalizationUnits("unitID", (Collection<LocalizationUnit>)Arrays.asList(lu1, lu2));
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDisplayName(new TranslatableString("conName", "conNameKey"));
        this.unit.setCondition(condition);
        Condition con1 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con1.setDisplayName(new TranslatableString("con1Name", "con1NameKey"));
        ConditionalDerivedVariableExpression exp1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp1Expression", con1);
        Condition con2 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con2.setDisplayName(new TranslatableString("con2Name", "con2NameKey"));
        ConditionalDerivedVariableExpression exp2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp2Expression", con2);
        ConditionalDerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var1ID", (Collection<ConditionalDerivedVariableExpression>)Arrays.asList(exp1, exp2));
        Condition con3 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con3.setDisplayName(new TranslatableString("con3Name", "con3NameKey"));
        ConditionalDerivedVariableExpression exp3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp3Expression", con3);
        Condition con4 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con4.setDisplayName(new TranslatableString("con4Name", "con4NameKey"));
        ConditionalDerivedVariableExpression exp4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp4Expression", con4);
        ConditionalDerivedVariable var2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var2ID", (Collection<ConditionalDerivedVariableExpression>)Arrays.asList(exp3, exp4));
        this.unit.setConditionalDerivedVariables((Collection<ConditionalDerivedVariable>)Arrays.asList(var1, var2));
        DerivedVariable dvar1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar1ID", "dvar1Expression");
        DerivedVariable dvar2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar2ID", "dvar2Expression");
        this.unit.setDerivedVariables((Collection<DerivedVariable>)Arrays.asList(dvar1, dvar2));
        Identity identity = SPISession.DEFAULT_INSTANCE.createBaseFactory().createIdentity(new TranslatableString("name", "nameKey"));
        this.unit.setIdentityData(identity);
        BooleanParameter param1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param1ID");
        BooleanParameter param2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param2ID");
        ParameterGroup group1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        group1.setBooleanParameters((Collection<BooleanParameter>)Arrays.asList(param1, param2));
        BooleanParameter param3 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param3ID");
        BooleanParameter param4 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param4ID");
        ParameterGroup group2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        group2.setBooleanParameters((Collection<BooleanParameter>)Arrays.asList(param3, param4));
        this.unit.setParameterGroups((Collection<ParameterGroup>)Arrays.asList(group1, group2));
        Requirement req1 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req1ID");
        Requirement req2 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req2ID");
        this.unit.setRequirements((Collection<Requirement>)Arrays.asList(req1, req2));
        ResourceProperty prop1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop1ID", "prop1Ref");
        ResourceProperty prop2 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop2ID", "prop2Ref");
        this.unit.setResourceProperties((Collection<ResourceProperty>)Arrays.asList(prop1, prop2));
        Completion comp1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompletion("comp1Type", "comp1Ref");
        Completion comp2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompletion("comp2Type", "comp2Ref");
        this.unit.setCompletions((Collection<Completion>)Arrays.asList(comp1, comp2));
        ReferencedPackage package1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package1Ref", "package1ID");
        ReferencedPackage package2 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package2Ref", "package2ID");
        this.unit.setContainedLocalizationPackages((Collection<ReferencedPackage>)Arrays.asList(package1, package2));
        ReferencedPackage package3 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package3Ref", "package3ID");
        ReferencedPackage package4 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package4Ref", "package4ID");
        CompositeLocalizationUnit comploc1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc1ID", (Collection<ReferencedPackage>)Arrays.asList(package3, package4));
        ReferencedPackage package5 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package5Ref", "package5ID");
        ReferencedPackage package6 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package6Ref", "package6ID");
        CompositeLocalizationUnit comploc2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc2ID", (Collection<ReferencedPackage>)Arrays.asList(package5, package6));
        this.unit.setCompositeLocalizationUnits((Collection<CompositeLocalizationUnit>)Arrays.asList(comploc1, comploc2));
        ResultingResource res1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res1Ref");
        ResultingResource res2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res2Ref");
        this.unit.setResultingResources((Collection<ResultingResource>)Arrays.asList(res1, res2));
        RequiredBase base = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createRequiredBase();
        base.setDisplayName(new TranslatableString("baseName", "baseKey"));
        this.unit.setRequiredBase(base);
        RequiredBase locBase = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createLocalizationBase();
        locBase.setDisplayName(new TranslatableString("locBaseName", "locBaseKey"));
        this.unit.setLocalizationBase(locBase);
        Language lang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang1Type");
        Language lang2 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang2Type");
        this.unit.setLanguages((Collection<Language>)Arrays.asList(lang1, lang2));
        this.clonedUnit = (CompositeLocalizationUnit)this.unit.clone();
        this.element = ((SPIDataObject)((Object)this.unit)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.unit)).getTranslatableStrings();
        CompositeLocalizationUnit_Test.assertEquals((int)8, (int)props.size());
        CompositeLocalizationUnit_Test.assertEquals((String)"conName", (String)props.getProperty("conNameKey"));
        CompositeLocalizationUnit_Test.assertEquals((String)"con1Name", (String)props.getProperty("con1NameKey"));
        CompositeLocalizationUnit_Test.assertEquals((String)"con2Name", (String)props.getProperty("con2NameKey"));
        CompositeLocalizationUnit_Test.assertEquals((String)"con3Name", (String)props.getProperty("con3NameKey"));
        CompositeLocalizationUnit_Test.assertEquals((String)"con4Name", (String)props.getProperty("con4NameKey"));
        CompositeLocalizationUnit_Test.assertEquals((String)"name", (String)props.getProperty("nameKey"));
        CompositeLocalizationUnit_Test.assertEquals((String)"baseName", (String)props.getProperty("baseKey"));
        CompositeLocalizationUnit_Test.assertEquals((String)"locBaseName", (String)props.getProperty("locBaseKey"));
    }

    public void testGetCompletions() {
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getCompletions().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp1Type", (String)this.unit.getCompletions().toArray(new Completion[0])[0].getCompletionType());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp1Ref", (String)this.unit.getCompletions().toArray(new Completion[0])[0].getCompletionResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp2Type", (String)this.unit.getCompletions().toArray(new Completion[0])[1].getCompletionType());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp2Ref", (String)this.unit.getCompletions().toArray(new Completion[0])[1].getCompletionResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getCompletions().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp1Type", (String)this.clonedUnit.getCompletions().toArray(new Completion[0])[0].getCompletionType());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp1Ref", (String)this.clonedUnit.getCompletions().toArray(new Completion[0])[0].getCompletionResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp2Type", (String)this.clonedUnit.getCompletions().toArray(new Completion[0])[1].getCompletionType());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp2Ref", (String)this.clonedUnit.getCompletions().toArray(new Completion[0])[1].getCompletionResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "Completion").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp1Type", (String)this.session.getChildren(this.element, "Completion").toArray(new Element[0])[0].getAttribute("type"));
        CompositeLocalizationUnit_Test.assertEquals((String)"comp1Ref", (String)this.session.getChildren(this.element, "Completion").toArray(new Element[0])[0].getAttribute("resourceRef"));
        CompositeLocalizationUnit_Test.assertEquals((String)"comp2Type", (String)this.session.getChildren(this.element, "Completion").toArray(new Element[0])[1].getAttribute("type"));
        CompositeLocalizationUnit_Test.assertEquals((String)"comp2Ref", (String)this.session.getChildren(this.element, "Completion").toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetCompositeLocalizationUnits() {
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getCompositeLocalizationUnits().size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"comploc1ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package3ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package3Ref", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"package4ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package4Ref", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"comploc2ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package5ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package5Ref", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"package6ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package6Ref", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getCompositeLocalizationUnits().size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"comploc1ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package3ID", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package3Ref", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"package4ID", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package4Ref", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"comploc2ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package5ID", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package5Ref", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"package6ID", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package6Ref", (String)this.clonedUnit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[1].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "CompositeLocalizationUnit").size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"comploc1ID", (String)this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package3Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package4ID", (String)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package4Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
        CompositeLocalizationUnit_Test.assertEquals((String)"comploc2ID", (String)this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[1].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package5ID", (String)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package5Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package6ID", (String)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package6Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[1], "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetCondition() {
        CompositeLocalizationUnit_Test.assertEquals((String)"conName", (String)this.unit.getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"conNameKey", (String)this.unit.getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"conName", (String)this.clonedUnit.getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"conNameKey", (String)this.clonedUnit.getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"conName", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"conNameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetContainedLocalizationPackages() {
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getContainedLocalizationPackages().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"package1ID", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package1Ref", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"package2ID", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package2Ref", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getContainedLocalizationPackages().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"package1ID", (String)this.clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package1Ref", (String)this.clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"package2ID", (String)this.clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package2Ref", (String)this.clonedUnit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[1].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "ContainedLocalizationPackage").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"package1ID", (String)this.session.getChildren(this.element, "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package1Ref", (String)this.session.getChildren(this.element, "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package2ID", (String)this.session.getChildren(this.element, "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package2Ref", (String)this.session.getChildren(this.element, "ContainedLocalizationPackage").toArray(new Element[0])[1].getAttribute("contentRef"));
    }

    public void testGetLocalizationBase() {
        CompositeLocalizationUnit_Test.assertEquals((String)"locBaseName", (String)this.unit.getLocalizationBase().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"locBaseKey", (String)this.unit.getLocalizationBase().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"locBaseName", (String)this.clonedUnit.getLocalizationBase().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"locBaseKey", (String)this.clonedUnit.getLocalizationBase().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"locBaseName", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"locBaseKey", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetLocalizationUnits() {
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getLocalizationUnits().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu1ID", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu1ResourceRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"art1ContentRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu2ID", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu2ResourceRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getTargetResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"art2ContentRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getInstallArtifact().getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getLocalizationUnits().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu1ID", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu1ResourceRef", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"art1ContentRef", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu2ID", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu2ResourceRef", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getTargetResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"art2ContentRef", (String)this.clonedUnit.getLocalizationUnits().toArray(new LocalizationUnit[0])[1].getInstallArtifact().getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "LocalizationUnit").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu1ID", (String)this.session.getChildren(this.element, "LocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"lu1ResourceRef", (String)this.session.getChildren(this.element, "LocalizationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeLocalizationUnit_Test.assertEquals((String)"art1ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
        CompositeLocalizationUnit_Test.assertEquals((String)"lu2ID", (String)this.session.getChildren(this.element, "LocalizationUnit").toArray(new Element[0])[1].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"lu2ResourceRef", (String)this.session.getChildren(this.element, "LocalizationUnit").toArray(new Element[0])[1].getAttribute("targetResourceRef"));
        CompositeLocalizationUnit_Test.assertEquals((String)"art2ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationUnit").toArray(new Element[0])[1], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testGetRequiredBase() {
        CompositeLocalizationUnit_Test.assertEquals((String)"baseName", (String)this.unit.getRequiredBase().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"baseKey", (String)this.unit.getRequiredBase().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"baseName", (String)this.clonedUnit.getRequiredBase().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"baseKey", (String)this.clonedUnit.getRequiredBase().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"baseName", (String)this.session.getChildren(this.session.getChildren(this.element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"baseKey", (String)this.session.getChildren(this.session.getChildren(this.element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetRequirements() {
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getRequirements().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"req1ID", (String)this.unit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        CompositeLocalizationUnit_Test.assertEquals((String)"req2ID", (String)this.unit.getRequirements().toArray(new Requirement[0])[1].getRequirementID());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getRequirements().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"req1ID", (String)this.clonedUnit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        CompositeLocalizationUnit_Test.assertEquals((String)"req2ID", (String)this.clonedUnit.getRequirements().toArray(new Requirement[0])[1].getRequirementID());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"req1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"req2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testGetResultingResources() {
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getResultingResources().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"res1Ref", (String)this.unit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"res2Ref", (String)this.unit.getResultingResources().toArray(new ResultingResource[0])[1].getResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getResultingResources().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"res1Ref", (String)this.clonedUnit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"res2Ref", (String)this.clonedUnit.getResultingResources().toArray(new ResultingResource[0])[1].getResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "ResultingResource").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"res1Ref", (String)this.session.getChildren(this.element, "ResultingResource").toArray(new Element[0])[0].getAttribute("resourceRef"));
        CompositeLocalizationUnit_Test.assertEquals((String)"res2Ref", (String)this.session.getChildren(this.element, "ResultingResource").toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetLanguages() {
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getLanguages().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"lang1Type", (String)this.unit.getLanguages().toArray(new Language[0])[0].getType());
        CompositeLocalizationUnit_Test.assertEquals((String)"lang2Type", (String)this.unit.getLanguages().toArray(new Language[0])[1].getType());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getLanguages().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"lang1Type", (String)this.clonedUnit.getLanguages().toArray(new Language[0])[0].getType());
        CompositeLocalizationUnit_Test.assertEquals((String)"lang2Type", (String)this.clonedUnit.getLanguages().toArray(new Language[0])[1].getType());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Language").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"lang1Type", (String)this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
        CompositeLocalizationUnit_Test.assertEquals((String)"lang2Type", (String)this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Language").toArray(new Element[0])[1].getAttribute("type"));
    }

    public void testGetContentUnitID() {
        CompositeLocalizationUnit_Test.assertEquals((String)"unitID", (String)this.unit.getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"unitID", (String)this.clonedUnit.getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"unitID", (String)this.element.getAttribute("id"));
    }

    public void testGetIdentityData() {
        CompositeLocalizationUnit_Test.assertEquals((String)"name", (String)this.unit.getIdentityData().getName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"nameKey", (String)this.unit.getIdentityData().getName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"name", (String)this.clonedUnit.getIdentityData().getName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"nameKey", (String)this.clonedUnit.getIdentityData().getName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"name", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"nameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetDerivedVariables() {
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getDerivedVariables().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar1ID", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar1Expression", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar2ID", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar2Expression", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getDerivedVariables().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar1ID", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar1Expression", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar2ID", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar2Expression", (String)this.clonedUnit.getDerivedVariables().toArray(new DerivedVariable[0])[1].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((int)4, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar1Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[3].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar2Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[3], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testGetConditionalDerivedVariables() {
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getConditionalDerivedVariables().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"var1ID", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"exp1Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((String)"con1Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"con1NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"exp2Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((String)"con2Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"con2NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"var2ID", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"exp3Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((String)"con3Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"con3NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"exp4Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((String)"con4Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"con4NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getConditionalDerivedVariables().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"var1ID", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"exp1Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((String)"con1Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"con1NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"exp2Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((String)"con2Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"con2NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"var2ID", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"exp3Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((String)"con3Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"con3NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"exp4Expression", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((String)"con4Name", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"con4NameKey", (String)this.clonedUnit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[1].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[1].getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((int)4, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"var1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"exp1Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"con1Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"con1NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        CompositeLocalizationUnit_Test.assertEquals((String)"exp2Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"con2Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"con2NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[0], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        CompositeLocalizationUnit_Test.assertEquals((String)"var2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"exp3Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"con3Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"con3NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
        CompositeLocalizationUnit_Test.assertEquals((String)"exp4Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"con4Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"con4NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[1], "ConditionalExpression").toArray(new Element[0])[1], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetResourceProperties() {
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getResourceProperties().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop1ID", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop1Ref", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop2ID", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[1].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop2Ref", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[1].getResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getResourceProperties().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop1ID", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop1Ref", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop2ID", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[1].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop2Ref", (String)this.clonedUnit.getResourceProperties().toArray(new ResourceProperty[0])[1].getResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop1ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"prop1Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("resourceRef"));
        CompositeLocalizationUnit_Test.assertEquals((String)"prop2ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[1].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"prop2Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[1].getAttribute("resourceRef"));
    }

    public void testGetParameterGroups() {
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getParameterGroups().size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"param1ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeLocalizationUnit_Test.assertEquals((String)"param2ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeLocalizationUnit_Test.assertEquals((String)"param3ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeLocalizationUnit_Test.assertEquals((String)"param4ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getParameterGroups().size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"param1ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeLocalizationUnit_Test.assertEquals((String)"param2ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeLocalizationUnit_Test.assertEquals((String)"param3ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeLocalizationUnit_Test.assertEquals((String)"param4ID", (String)this.clonedUnit.getParameterGroups().toArray(new ParameterGroup[0])[1].getBooleanParameters().toArray(new BooleanParameter[0])[1].getParameterID());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").size());
        CompositeLocalizationUnit_Test.assertEquals((int)2, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"param1ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"param2ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[1].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"param3ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"param4ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[1], "BooleanParameter").toArray(new Element[0])[1].getAttribute("id"));
    }

    public void testSetCompletions() {
        Completion comp1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompletion("comp3Type", "comp3Ref");
        this.unit.setCompletions((Collection<Completion>)Arrays.asList(comp1));
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getCompletions().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp3Type", (String)this.unit.getCompletions().toArray(new Completion[0])[0].getCompletionType());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp3Ref", (String)this.unit.getCompletions().toArray(new Completion[0])[0].getCompletionResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "Completion").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"comp3Type", (String)this.session.getChildren(this.element, "Completion").toArray(new Element[0])[0].getAttribute("type"));
        CompositeLocalizationUnit_Test.assertEquals((String)"comp3Ref", (String)this.session.getChildren(this.element, "Completion").toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetCompositeLocalizationUnits() {
        ReferencedPackage package8 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package8Ref", "package8ID");
        CompositeLocalizationUnit comploc3 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createCompositeLocalizationUnitWithContainedLocalizationPackages("comploc3ID", (Collection<ReferencedPackage>)Arrays.asList(package8));
        this.unit.setCompositeLocalizationUnits((Collection<CompositeLocalizationUnit>)Arrays.asList(comploc3));
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getCompositeLocalizationUnits().size());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"comploc3ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package8ID", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package8Ref", (String)this.unit.getCompositeLocalizationUnits().toArray(new CompositeLocalizationUnit[0])[0].getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "CompositeLocalizationUnit").size());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"comploc3ID", (String)this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package8ID", (String)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package8Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "CompositeLocalizationUnit").toArray(new Element[0])[0], "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetCondition() {
        Condition condition = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        condition.setDisplayName(new TranslatableString("differentName", "differentNameKey"));
        this.unit.setCondition(condition);
        CompositeLocalizationUnit_Test.assertEquals((String)"differentName", (String)this.unit.getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentNameKey", (String)this.unit.getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentNameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetContainedLocalizationPackages() {
        ReferencedPackage package1 = SPISession.DEFAULT_INSTANCE.createBaseFactory().createContainedLocalizationPackage("package7Ref", "package7ID");
        this.unit.setContainedLocalizationPackages((Collection<ReferencedPackage>)Arrays.asList(package1));
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getContainedLocalizationPackages().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"package7ID", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getReferencedPackageID());
        CompositeLocalizationUnit_Test.assertEquals((String)"package7Ref", (String)this.unit.getContainedLocalizationPackages().toArray(new ReferencedPackage[0])[0].getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "ContainedLocalizationPackage").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"package7ID", (String)this.session.getChildren(this.element, "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"package7Ref", (String)this.session.getChildren(this.element, "ContainedLocalizationPackage").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetLocalizationBase() {
        RequiredBase locBase = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createLocalizationBase();
        locBase.setDisplayName(new TranslatableString("differentBaseName", "differentBaseKey"));
        this.unit.setLocalizationBase(locBase);
        CompositeLocalizationUnit_Test.assertEquals((String)"differentBaseName", (String)this.unit.getLocalizationBase().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentBaseKey", (String)this.unit.getLocalizationBase().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentBaseName", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentBaseKey", (String)this.session.getChildren(this.session.getChildren(this.element, "LocalizationBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetLocalizationUnits() {
        Artifact art1 = SPISession.DEFAULT_INSTANCE.createArtifactFactory().createInstallArtifact();
        art1.setContentReference("art3ContentRef");
        LocalizationUnit lu1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLocalizationUnit("lu3ID", "lu3ResourceRef", art1, 0);
        this.unit.setLocalizationUnits((Collection<LocalizationUnit>)Arrays.asList(lu1));
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getLocalizationUnits().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu3ID", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu3ResourceRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getTargetResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((String)"art3ContentRef", (String)this.unit.getLocalizationUnits().toArray(new LocalizationUnit[0])[0].getInstallArtifact().getContentReference());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "LocalizationUnit").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"lu3ID", (String)this.session.getChildren(this.element, "LocalizationUnit").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"lu3ResourceRef", (String)this.session.getChildren(this.element, "LocalizationUnit").toArray(new Element[0])[0].getAttribute("targetResourceRef"));
        CompositeLocalizationUnit_Test.assertEquals((String)"art3ContentRef", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "LocalizationUnit").toArray(new Element[0])[0], "Artifacts").toArray(new Element[0])[0], "InstallArtifact").toArray(new Element[0])[0].getAttribute("contentRef"));
    }

    public void testSetRequiredBase() {
        RequiredBase base = SPISession.DEFAULT_INSTANCE.createRequiredBaseFactory().createRequiredBase();
        base.setDisplayName(new TranslatableString("differentName", "differentKey"));
        this.unit.setRequiredBase(base);
        CompositeLocalizationUnit_Test.assertEquals((String)"differentName", (String)this.unit.getRequiredBase().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentKey", (String)this.unit.getRequiredBase().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.session.getChildren(this.element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentKey", (String)this.session.getChildren(this.session.getChildren(this.element, "RequiredBase").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetRequirements() {
        Requirement req1 = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRequirement("req3ID");
        this.unit.setRequirements((Collection<Requirement>)Arrays.asList(req1));
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getRequirements().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"req3ID", (String)this.unit.getRequirements().toArray(new Requirement[0])[0].getRequirementID());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"req3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Requirements").toArray(new Element[0])[0], "Requirement").toArray(new Element[0])[0].getAttribute("id"));
    }

    public void testSetResultingResources() {
        ResultingResource res1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createResultingResource("res3Ref");
        this.unit.setResultingResources((Collection<ResultingResource>)Arrays.asList(res1));
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getResultingResources().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"res3Ref", (String)this.unit.getResultingResources().toArray(new ResultingResource[0])[0].getResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.element, "ResultingResource").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"res3Ref", (String)this.session.getChildren(this.element, "ResultingResource").toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetLanguages() {
        Language lang1 = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createLanguage("lang3Type");
        this.unit.setLanguages((Collection<Language>)Arrays.asList(lang1));
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getLanguages().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"lang3Type", (String)this.unit.getLanguages().toArray(new Language[0])[0].getType());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Language").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"lang3Type", (String)this.session.getChildren(this.session.getChildren(this.element, "Languages").toArray(new Element[0])[0], "Language").toArray(new Element[0])[0].getAttribute("type"));
    }

    public void testSetContentUnitID() {
        this.unit.setContentUnitID("differentID");
        CompositeLocalizationUnit_Test.assertEquals((String)"differentID", (String)this.unit.getContentUnitID());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentID", (String)this.element.getAttribute("id"));
    }

    public void testSetIdentityData() {
        Identity identity = SPISession.DEFAULT_INSTANCE.createBaseFactory().createIdentity(new TranslatableString("differentName", "differentNameKey"));
        this.unit.setIdentityData(identity);
        CompositeLocalizationUnit_Test.assertEquals((String)"differentName", (String)this.unit.getIdentityData().getName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentNameKey", (String)this.unit.getIdentityData().getName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentName", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"differentNameKey", (String)this.session.getChildren(this.session.getChildren(this.element, "Identity").toArray(new Element[0])[0], "Name").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetResourceProperties() {
        ResourceProperty prop1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createResourceProperty("prop3ID", "prop3Ref");
        this.unit.setResourceProperties((Collection<ResourceProperty>)Arrays.asList(prop1));
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getResourceProperties().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop3ID", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop3Ref", (String)this.unit.getResourceProperties().toArray(new ResourceProperty[0])[0].getResourceReference());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"prop3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"prop3Ref", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "ResourceProperty").toArray(new Element[0])[0].getAttribute("resourceRef"));
    }

    public void testSetDerivedVariables() {
        DerivedVariable dvar1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createDerivedVariable("dvar3ID", "dvar3Expression");
        this.unit.setDerivedVariables((Collection<DerivedVariable>)Arrays.asList(dvar1));
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getDerivedVariables().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar3ID", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar3Expression", (String)this.unit.getDerivedVariables().toArray(new DerivedVariable[0])[0].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((int)3, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"dvar3Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "Expression").toArray(new Element[0])[0].getTextContent());
    }

    public void testSetConditionalDerivedVariables() {
        Condition con1 = SPISession.DEFAULT_INSTANCE.createConditionFactory().createCondition();
        con1.setDisplayName(new TranslatableString("con5Name", "con5NameKey"));
        ConditionalDerivedVariableExpression exp1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariableExpression("exp3Expression", con1);
        ConditionalDerivedVariable var1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createConditionalDerivedVariable("var3ID", (Collection<ConditionalDerivedVariableExpression>)Arrays.asList(exp1));
        this.unit.setConditionalDerivedVariables((Collection<ConditionalDerivedVariable>)Arrays.asList(var1));
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getConditionalDerivedVariables().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"var3ID", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getVariableID());
        CompositeLocalizationUnit_Test.assertEquals((String)"exp3Expression", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getExpression());
        CompositeLocalizationUnit_Test.assertEquals((String)"con5Name", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getValue());
        CompositeLocalizationUnit_Test.assertEquals((String)"con5NameKey", (String)this.unit.getConditionalDerivedVariables().toArray(new ConditionalDerivedVariable[0])[0].getConditionalDerivedExpressions().toArray(new ConditionalDerivedVariableExpression[0])[0].getCondition().getDisplayName().getTranslationKey());
        CompositeLocalizationUnit_Test.assertEquals((int)3, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"var3ID", (String)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2].getAttribute("id"));
        CompositeLocalizationUnit_Test.assertEquals((String)"exp3Expression", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Expression").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"con5Name", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getTextContent());
        CompositeLocalizationUnit_Test.assertEquals((String)"con5NameKey", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "DerivedVariable").toArray(new Element[0])[2], "ConditionalExpression").toArray(new Element[0])[0], "Condition").toArray(new Element[0])[0], "DisplayName").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetParameterGroups() {
        BooleanParameter param1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createBooleanParameter("param5ID");
        ParameterGroup group1 = SPISession.DEFAULT_INSTANCE.createVariableFactory().createParameterGroup();
        group1.setBooleanParameters((Collection<BooleanParameter>)Arrays.asList(param1));
        this.unit.setParameterGroups((Collection<ParameterGroup>)Arrays.asList(group1));
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getParameterGroups().size());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().size());
        CompositeLocalizationUnit_Test.assertEquals((String)"param5ID", (String)this.unit.getParameterGroups().toArray(new ParameterGroup[0])[0].getBooleanParameters().toArray(new BooleanParameter[0])[0].getParameterID());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").size());
        CompositeLocalizationUnit_Test.assertEquals((int)1, (int)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").size());
        CompositeLocalizationUnit_Test.assertEquals((String)"param5ID", (String)this.session.getChildren(this.session.getChildren(this.session.getChildren(this.element, "Variables").toArray(new Element[0])[0], "Parameters").toArray(new Element[0])[0], "BooleanParameter").toArray(new Element[0])[0].getAttribute("id"));
    }
}

