/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConstrainedResource;
import org.w3c.dom.Element;

public class ConstrainedResource_Test
extends TestCase {
    ConstrainedResource resource;
    ConstrainedResource clonedResource;
    Element element;

    public ConstrainedResource_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.resource = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createConstrainedResource("resourceRef");
        this.resource.setConstraintType("resourceType");
        this.clonedResource = this.resource;
        this.element = ((SPIDataObject)((Object)this.resource)).getElement();
    }

    public void testGetConstraintType() {
        ConstrainedResource_Test.assertEquals((String)"resourceType", (String)this.resource.getConstraintType());
        ConstrainedResource_Test.assertEquals((String)"resourceType", (String)this.clonedResource.getConstraintType());
        ConstrainedResource_Test.assertEquals((String)"resourceType", (String)this.element.getAttribute("constraintType"));
    }

    public void testGetResourceRef() {
        ConstrainedResource_Test.assertEquals((String)"resourceRef", (String)this.resource.getResourceRef());
        ConstrainedResource_Test.assertEquals((String)"resourceRef", (String)this.clonedResource.getResourceRef());
        ConstrainedResource_Test.assertEquals((String)"resourceRef", (String)this.element.getAttribute("resourceRef"));
    }

    public void testSetConstraintType() {
        this.resource.setConstraintType("differentType");
        ConstrainedResource_Test.assertEquals((String)"differentType", (String)this.resource.getConstraintType());
        ConstrainedResource_Test.assertEquals((String)"differentType", (String)this.element.getAttribute("constraintType"));
    }

    public void testSetResourceRef() {
        this.resource.setResourceRef("differentRef");
        ConstrainedResource_Test.assertEquals((String)"differentRef", (String)this.resource.getResourceRef());
        ConstrainedResource_Test.assertEquals((String)"differentRef", (String)this.clonedResource.getResourceRef());
        ConstrainedResource_Test.assertEquals((String)"differentRef", (String)this.element.getAttribute("resourceRef"));
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.resource)).getTranslatableStrings();
        ConstrainedResource_Test.assertEquals((int)0, (int)props.size());
    }
}

