/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ContentSelectionFeature;
import org.w3c.dom.Element;

public class ContentSelectionFeature_Test
extends TestCase {
    ContentSelectionFeature feature;
    ContentSelectionFeature clonedFeature;
    Element element;

    public ContentSelectionFeature_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.feature = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createContentSelectionFeature("feature");
        this.feature.setSelections("selections");
        this.clonedFeature = (ContentSelectionFeature)this.feature.clone();
        this.element = ((SPIDataObject)((Object)this.feature)).getElement();
    }

    public void testGetFeature() {
        ContentSelectionFeature_Test.assertEquals((String)"feature", (String)this.feature.getFeature());
        ContentSelectionFeature_Test.assertEquals((String)"feature", (String)this.clonedFeature.getFeature());
        ContentSelectionFeature_Test.assertEquals((String)"feature", (String)this.element.getTextContent());
    }

    public void testGetSelections() {
        ContentSelectionFeature_Test.assertEquals((String)"selections", (String)this.feature.getSelections());
        ContentSelectionFeature_Test.assertEquals((String)"selections", (String)this.clonedFeature.getSelections());
        ContentSelectionFeature_Test.assertEquals((String)"selections", (String)this.element.getAttribute("selections"));
    }

    public void testSetFeature() {
        this.feature.setFeature("differentFeature");
        ContentSelectionFeature_Test.assertEquals((String)"differentFeature", (String)this.feature.getFeature());
        ContentSelectionFeature_Test.assertEquals((String)"differentFeature", (String)this.element.getTextContent());
        try {
            this.feature.setFeature(null);
            ContentSelectionFeature_Test.fail((String)"Feature was set to null");
        }
        catch (Exception exception) {}
    }

    public void testSetSelections() {
        this.feature.setSelections("differentSelections");
        ContentSelectionFeature_Test.assertEquals((String)"differentSelections", (String)this.feature.getSelections());
        ContentSelectionFeature_Test.assertEquals((String)"differentSelections", (String)this.element.getAttribute("selections"));
    }

    public void testGetTranslatableStrings() {
        Properties props = ((SPIDataObject)((Object)this.feature)).getTranslatableStrings();
        ContentSelectionFeature_Test.assertEquals((int)0, (int)props.keySet().size());
    }
}

