/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.math.BigInteger;
import java.util.Arrays;
import java.util.Collection;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.MultiFeatureSelect;
import org.w3c.dom.Element;

public class MultiFeatureSelect_Test
extends TestCase {
    MultiFeatureSelect featureSelect;
    MultiFeatureSelect clonedFeatureSelect;
    Element element;
    SPISessionImpl session;

    public MultiFeatureSelect_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.featureSelect = SPISession.DEFAULT_INSTANCE.createContentUnitFactory().createMultiFeatureSelect((Collection<String>)Arrays.asList("feature1", "feature2"));
        this.featureSelect.setMaxSelections(BigInteger.valueOf(5L));
        this.featureSelect.setMinSelections(BigInteger.valueOf(4L));
        this.clonedFeatureSelect = (MultiFeatureSelect)this.featureSelect.clone();
        this.element = ((SPIDataObject)((Object)this.featureSelect)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        MultiFeatureSelect_Test.assertEquals((int)0, (int)((SPIDataObject)((Object)this.featureSelect)).getTranslatableStrings().size());
    }

    public void testGetFeatures() {
        MultiFeatureSelect_Test.assertEquals((int)2, (int)this.featureSelect.getFeatures().size());
        MultiFeatureSelect_Test.assertEquals((int)2, (int)this.clonedFeatureSelect.getFeatures().size());
        MultiFeatureSelect_Test.assertEquals((int)2, (int)this.session.getChildren(this.element, "Feature").size());
        MultiFeatureSelect_Test.assertEquals((String)"feature1", (String)this.featureSelect.getFeatures().toArray(new String[0])[0]);
        MultiFeatureSelect_Test.assertEquals((String)"feature2", (String)this.featureSelect.getFeatures().toArray(new String[0])[1]);
        MultiFeatureSelect_Test.assertEquals((String)"feature1", (String)this.clonedFeatureSelect.getFeatures().toArray(new String[0])[0]);
        MultiFeatureSelect_Test.assertEquals((String)"feature2", (String)this.clonedFeatureSelect.getFeatures().toArray(new String[0])[1]);
        MultiFeatureSelect_Test.assertEquals((String)"feature1", (String)this.session.getChildren(this.element, "Feature").toArray(new Element[0])[0].getAttribute("featureRef"));
        MultiFeatureSelect_Test.assertEquals((String)"feature2", (String)this.session.getChildren(this.element, "Feature").toArray(new Element[0])[1].getAttribute("featureRef"));
    }

    public void testGetMaximumSelections() {
        MultiFeatureSelect_Test.assertEquals((int)5, (int)this.featureSelect.getMaxSelections().intValue());
        MultiFeatureSelect_Test.assertEquals((int)5, (int)this.clonedFeatureSelect.getMaxSelections().intValue());
        MultiFeatureSelect_Test.assertEquals((int)5, (int)Integer.parseInt(this.element.getAttribute("maxSelections")));
    }

    public void testGetMinimumSelections() {
        MultiFeatureSelect_Test.assertEquals((int)4, (int)this.featureSelect.getMinSelections().intValue());
        MultiFeatureSelect_Test.assertEquals((int)4, (int)this.clonedFeatureSelect.getMinSelections().intValue());
        MultiFeatureSelect_Test.assertEquals((int)4, (int)Integer.parseInt(this.element.getAttribute("minSelections")));
    }

    public void testSetFeatures() {
        this.featureSelect.setFeatures((Collection<String>)Arrays.asList("feature3", "feature4", "feature5"));
        MultiFeatureSelect_Test.assertEquals((int)3, (int)this.featureSelect.getFeatures().size());
        MultiFeatureSelect_Test.assertEquals((int)3, (int)this.session.getChildren(this.element, "Feature").size());
        MultiFeatureSelect_Test.assertEquals((String)"feature3", (String)this.featureSelect.getFeatures().toArray(new String[0])[0]);
        MultiFeatureSelect_Test.assertEquals((String)"feature4", (String)this.featureSelect.getFeatures().toArray(new String[0])[1]);
        MultiFeatureSelect_Test.assertEquals((String)"feature5", (String)this.featureSelect.getFeatures().toArray(new String[0])[2]);
        MultiFeatureSelect_Test.assertEquals((String)"feature3", (String)this.session.getChildren(this.element, "Feature").toArray(new Element[0])[0].getAttribute("featureRef"));
        MultiFeatureSelect_Test.assertEquals((String)"feature4", (String)this.session.getChildren(this.element, "Feature").toArray(new Element[0])[1].getAttribute("featureRef"));
        MultiFeatureSelect_Test.assertEquals((String)"feature5", (String)this.session.getChildren(this.element, "Feature").toArray(new Element[0])[2].getAttribute("featureRef"));
        try {
            this.featureSelect.setFeatures((Collection<String>)Arrays.asList("feature"));
            MultiFeatureSelect_Test.fail((String)"Features set to only one feature");
        }
        catch (Exception exception) {}
        try {
            this.featureSelect.setFeatures(null);
            MultiFeatureSelect_Test.fail((String)"Features set to null");
        }
        catch (Exception exception) {}
    }

    public void testSetMaximumSelections() {
        this.featureSelect.setMaxSelections(BigInteger.valueOf(6L));
        MultiFeatureSelect_Test.assertEquals((int)6, (int)this.featureSelect.getMaxSelections().intValue());
        MultiFeatureSelect_Test.assertEquals((int)6, (int)Integer.parseInt(this.element.getAttribute("maxSelections")));
    }

    public void testSetMinimumSelections() {
        this.featureSelect.setMinSelections(BigInteger.valueOf(2L));
        MultiFeatureSelect_Test.assertEquals((int)2, (int)this.featureSelect.getMinSelections().intValue());
        MultiFeatureSelect_Test.assertEquals((int)2, (int)Integer.parseInt(this.element.getAttribute("minSelections")));
    }
}

