/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.common.spi;

import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPIDataObject;
import org.eclipse.cosmos.me.internal.deployment.sdd.common.spi.SPISessionImpl;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.SPISession;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.requirement.RelationshipConstraint;
import org.w3c.dom.Element;

public class RelationshipConstraint_Test
extends TestCase {
    RelationshipConstraint relConstraint;
    RelationshipConstraint clonedRelConstraint;
    Element element;
    SPISessionImpl session;

    public RelationshipConstraint_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.relConstraint = SPISession.DEFAULT_INSTANCE.createRequirementFactory().createRelationshipConstraint("constraintType");
        this.relConstraint.setDescription(new TranslatableString("desc", "descKey"));
        this.relConstraint.setShortDescription(new TranslatableString("shortDesc", "shortDescKey"));
        Properties props = new Properties();
        props.setProperty("key1", "value1");
        props.setProperty("key2", "value2");
        this.relConstraint.setProperties(props);
        this.relConstraint.setRelatedResourceRef("relResourceRef");
        this.clonedRelConstraint = (RelationshipConstraint)this.relConstraint.clone();
        this.element = ((SPIDataObject)((Object)this.relConstraint)).getElement();
        this.session = (SPISessionImpl)SPISession.DEFAULT_INSTANCE;
    }

    public void testGetTranslatableStrings() {
        Properties props = this.relConstraint.getTranslatableStrings();
        Properties clonedProps = this.clonedRelConstraint.getTranslatableStrings();
        RelationshipConstraint_Test.assertEquals((int)2, (int)props.keySet().size());
        RelationshipConstraint_Test.assertEquals((int)2, (int)clonedProps.keySet().size());
        RelationshipConstraint_Test.assertEquals((Object)"desc", (Object)props.get("descKey"));
        RelationshipConstraint_Test.assertEquals((Object)"shortDesc", (Object)props.get("shortDescKey"));
        RelationshipConstraint_Test.assertEquals((Object)"desc", (Object)clonedProps.get("descKey"));
        RelationshipConstraint_Test.assertEquals((Object)"shortDesc", (Object)clonedProps.get("shortDescKey"));
    }

    public void testGetProperties() {
        Properties testProps = this.relConstraint.getProperties();
        Properties testclonedProps = this.clonedRelConstraint.getProperties();
        Collection<Element> testDataObjectProps = this.session.getChildren(this.element, "Property");
        RelationshipConstraint_Test.assertEquals((Object)"value1", (Object)testProps.get("key1"));
        RelationshipConstraint_Test.assertEquals((Object)"value2", (Object)testProps.get("key2"));
        RelationshipConstraint_Test.assertEquals((Object)"value1", (Object)testclonedProps.get("key1"));
        RelationshipConstraint_Test.assertEquals((Object)"value2", (Object)testclonedProps.get("key2"));
        RelationshipConstraint_Test.assertEquals((int)2, (int)testDataObjectProps.size());
        int i = 0;
        while (i < testDataObjectProps.size()) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            String value = this.session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = this.session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            RelationshipConstraint_Test.assertTrue((String)(String.valueOf(value) + " wasn't found in the properties object"), (boolean)testProps.contains(value));
            RelationshipConstraint_Test.assertTrue((String)(String.valueOf(propertyName) + " wasn't found in the properties object"), (boolean)testProps.containsKey(propertyName));
            RelationshipConstraint_Test.assertEquals((Object)value, (Object)testProps.get(propertyName));
            ++i;
        }
    }

    public void testGetRelatedResourceReference() {
        RelationshipConstraint_Test.assertEquals((String)"relResourceRef", (String)this.relConstraint.getRelatedResourceReference());
        RelationshipConstraint_Test.assertEquals((String)"relResourceRef", (String)this.clonedRelConstraint.getRelatedResourceReference());
        RelationshipConstraint_Test.assertEquals((String)"relResourceRef", (String)this.element.getAttribute("relatedResourceRef"));
    }

    public void testGetType() {
        RelationshipConstraint_Test.assertEquals((String)"constraintType", (String)this.relConstraint.getType());
        RelationshipConstraint_Test.assertEquals((String)"constraintType", (String)this.clonedRelConstraint.getType());
        RelationshipConstraint_Test.assertEquals((String)"constraintType", (String)this.element.getAttribute("type"));
    }

    public void testGetDescription() {
        RelationshipConstraint_Test.assertEquals((String)"desc", (String)this.relConstraint.getDescription().getValue());
        RelationshipConstraint_Test.assertEquals((String)"descKey", (String)this.relConstraint.getDescription().getTranslationKey());
        RelationshipConstraint_Test.assertEquals((String)"desc", (String)this.clonedRelConstraint.getDescription().getValue());
        RelationshipConstraint_Test.assertEquals((String)"descKey", (String)this.clonedRelConstraint.getDescription().getTranslationKey());
        RelationshipConstraint_Test.assertEquals((String)"desc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        RelationshipConstraint_Test.assertEquals((String)"descKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testGetShortDescription() {
        RelationshipConstraint_Test.assertEquals((String)"shortDesc", (String)this.relConstraint.getShortDescription().getValue());
        RelationshipConstraint_Test.assertEquals((String)"shortDescKey", (String)this.relConstraint.getShortDescription().getTranslationKey());
        RelationshipConstraint_Test.assertEquals((String)"shortDesc", (String)this.clonedRelConstraint.getShortDescription().getValue());
        RelationshipConstraint_Test.assertEquals((String)"shortDescKey", (String)this.clonedRelConstraint.getShortDescription().getTranslationKey());
        RelationshipConstraint_Test.assertEquals((String)"shortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        RelationshipConstraint_Test.assertEquals((String)"shortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetProperties() {
        Properties props = new Properties();
        props.setProperty("key3", "value3");
        this.relConstraint.setProperties(props);
        Properties testProps = this.relConstraint.getProperties();
        Collection<Element> testDataObjectProps = this.session.getChildren(this.element, "Property");
        RelationshipConstraint_Test.assertEquals((int)1, (int)testDataObjectProps.size());
        RelationshipConstraint_Test.assertEquals((Object)"value3", (Object)testProps.get("key3"));
        int i = 0;
        while (i < testDataObjectProps.size()) {
            Element prop = testDataObjectProps.toArray(new Element[0])[i];
            String value = this.session.getChildren(prop, "Value").toArray(new Element[0])[0].getTextContent();
            String propertyName = this.session.getChildren(prop, "PropertyName").toArray(new Element[0])[0].getTextContent();
            RelationshipConstraint_Test.assertTrue((String)(String.valueOf(value) + " wasn't found in the properties object"), (boolean)testProps.contains(value));
            RelationshipConstraint_Test.assertTrue((String)(String.valueOf(propertyName) + " wasn't found in the properties object"), (boolean)testProps.containsKey(propertyName));
            RelationshipConstraint_Test.assertEquals((Object)value, (Object)testProps.get(propertyName));
            ++i;
        }
    }

    public void testSetRelatedResourceRef() {
        this.relConstraint.setRelatedResourceRef("differentRef");
        RelationshipConstraint_Test.assertEquals((String)"differentRef", (String)this.relConstraint.getRelatedResourceReference());
        RelationshipConstraint_Test.assertEquals((String)"differentRef", (String)this.element.getAttribute("relatedResourceRef"));
    }

    public void testSetType() {
        this.relConstraint.setType("differentType");
        RelationshipConstraint_Test.assertEquals((String)"differentType", (String)this.relConstraint.getType());
        RelationshipConstraint_Test.assertEquals((String)"differentType", (String)this.element.getAttribute("type"));
        try {
            this.relConstraint.setType(null);
            RelationshipConstraint_Test.fail((String)"Type was set to null");
        }
        catch (Exception exception) {}
    }

    public void testSetDescription() {
        this.relConstraint.setDescription(new TranslatableString("differentDesc", "differentDescKey"));
        RelationshipConstraint_Test.assertEquals((String)"differentDesc", (String)this.relConstraint.getDescription().getValue());
        RelationshipConstraint_Test.assertEquals((String)"differentDescKey", (String)this.relConstraint.getDescription().getTranslationKey());
        RelationshipConstraint_Test.assertEquals((String)"differentDesc", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getTextContent());
        RelationshipConstraint_Test.assertEquals((String)"differentDescKey", (String)this.session.getChildren(this.element, "Description").toArray(new Element[0])[0].getAttribute("translationKey"));
    }

    public void testSetShortDescription() {
        this.relConstraint.setShortDescription(new TranslatableString("differentShortDesc", "differentShortDescKey"));
        RelationshipConstraint_Test.assertEquals((String)"differentShortDesc", (String)this.relConstraint.getShortDescription().getValue());
        RelationshipConstraint_Test.assertEquals((String)"differentShortDescKey", (String)this.relConstraint.getShortDescription().getTranslationKey());
        RelationshipConstraint_Test.assertEquals((String)"differentShortDesc", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getTextContent());
        RelationshipConstraint_Test.assertEquals((String)"differentShortDescKey", (String)this.session.getChildren(this.element, "ShortDescription").toArray(new Element[0])[0].getAttribute("translationKey"));
    }
}

