/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.sdd;

import java.io.FileNotFoundException;
import java.util.Collection;
import java.util.Properties;
import junit.framework.TestCase;
import org.eclipse.cosmos.me.internal.deployment.sdd.tests.tooling.btg.sdd.AllTests;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.BTGProperty;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.SDDFragment;
import org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.sdd.SDDDataCollector;
import org.xml.sax.SAXParseException;

public class SDDDataCollector_Test
extends TestCase {
    SDDDataCollector sddDC;

    public SDDDataCollector_Test(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.sddDC = new SDDDataCollector();
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testGetSupportedProperties() throws Exception {
        Collection<BTGProperty> btgp = this.sddDC.getSupportedProperties();
        SDDDataCollector_Test.assertTrue((btgp != null ? 1 : 0) != 0);
        SDDDataCollector_Test.assertEquals((int)btgp.size(), (int)1);
        BTGProperty testProp = btgp.toArray(new BTGProperty[0])[0];
        SDDDataCollector_Test.assertEquals((String)"FileName", (String)testProp.getName());
        SDDDataCollector_Test.assertTrue((boolean)testProp.isRequired());
    }

    public void testValidDDFile() throws Exception {
        Properties props = new Properties();
        props.put("FileName", AllTests.VALID_DD);
        Collection<SDDFragment> sdds = this.sddDC.collectSDDData(props);
        SDDDataCollector_Test.assertNotNull(sdds);
        SDDDataCollector_Test.assertEquals((int)sdds.size(), (int)1);
        SDDFragment fragment = sdds.toArray(new SDDFragment[0])[0];
        SDDDataCollector_Test.assertTrue((boolean)fragment.getFragment().getDocumentElement().getNodeName().equals("sdd-dd:DeploymentDescriptor"));
    }

    public void testValidPDFile() throws Exception {
        Properties props = new Properties();
        props.put("FileName", AllTests.VALID_PD);
        Collection<SDDFragment> sdds = this.sddDC.collectSDDData(props);
        SDDDataCollector_Test.assertNotNull(sdds);
        SDDDataCollector_Test.assertEquals((int)sdds.size(), (int)1);
        SDDFragment fragment = sdds.toArray(new SDDFragment[0])[0];
        SDDDataCollector_Test.assertTrue((boolean)fragment.getFragment().getDocumentElement().getNodeName().equals("sdd-pd:PackageDescriptor"));
    }

    public void testInvalidDDFile() throws Exception {
        Properties props = new Properties();
        props.put("FileName", AllTests.INVALID_DD);
        try {
            this.sddDC.collectSDDData(props);
            SDDDataCollector_Test.fail((String)"Input XML is not well-formed but SAXParseException was not thrown");
        }
        catch (SAXParseException sAXParseException) {}
    }

    public void testInvalidPDFile() throws Exception {
        Properties props = new Properties();
        props.put("FileName", AllTests.INVALID_PD);
        try {
            this.sddDC.collectSDDData(props);
            SDDDataCollector_Test.fail((String)"Input XML is not well-formed but SAXParseException was not thrown");
        }
        catch (SAXParseException sAXParseException) {}
    }

    public void testInvalidFileName() throws Exception {
        Properties props = new Properties();
        props.put("FileName", "C:\\badfilename.xml");
        try {
            this.sddDC.collectSDDData(props);
            SDDDataCollector_Test.fail((String)"Did not throw FileNotFoundException when invalid file name is given.");
        }
        catch (FileNotFoundException fileNotFoundException) {}
    }
}

