/*******************************************************************************
 * Copyright (c) 2007, 2008 IBM Corporation
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     IBM Corporation - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.internal.deployment.sdd.resources.tooling.btg;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;

public class Messages {
	private static final String BUNDLE_NAME = "org.eclipse.cosmos.me.internal.deployment.sdd.resources.tooling.btg.messages"; //$NON-NLS-1$

	private static final ResourceBundle RESOURCE_BUNDLE = ResourceBundle.getBundle(BUNDLE_NAME);

	private Messages() {
	}
	
	/**
     * Looks in the resource bundle for the key. If the key is not found, the key will be the message.
     * Elements in the format of {0} inside the message will be replaced by the parm variable. 
     * 
     * @param key - Key to look for in the resource bundle. If it's not found, then the key is the message.
     * @param parms - Value used for replacement in the message.
     * @return Formatted string retrieved from the resource bundle.
     */
    public static String getString(String key, String parm) {
        return getString(key, new String[] {parm});
    }
    
    /**
     * Looks in the resource bundle for the key. If the key is not found, the key will be the message.
     * Elements in the format of {N} inside the message will be replaced by the value parms[N]. 
     * 
     * @param key - Key to look for in the resource bundle. If it's not found, then the key is the message.
     * @param parms - Values used for replacement in the message.
     * @return Formatted string retrieved from the resource bundle.
     */
    public static String getString (String key, String[] parms) {
        String value;
        
        try {
        	value = RESOURCE_BUNDLE.getString(key);
        } catch (MissingResourceException e) {
            value = key;
        }
        
        for (int i = 0; i < parms.length; i++) {
        	parms[i] = Matcher.quoteReplacement(parms[i]);
            value = value.replaceAll("\\{" + i + "\\}", parms[i]); //$NON-NLS-1$ //$NON-NLS-2$
        }
        
        return (value);
    }
    
    /**
     * Looks in the resource bundle for the key. If the key is not found, the string !key! is returned.
     * 
     * @param key - Key to look for in the resource bundle. If it's not found, then the string !key! is returned.
     * @return String retrieved from the resource bundle.
     */
	public static String getString(String key) {
		try {
			return RESOURCE_BUNDLE.getString(key);
		} catch (MissingResourceException e) {
			return '!' + key + '!';
		}
	}
}
