/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.condition.Condition;

public class ConditionType {
	
	public static boolean equals(Condition condition1, Condition condition2)
	{
		
		Collection<String> operations1 = condition1.getOperations();
		Collection<String> operations2 = condition2.getOperations();
				
		return OperationsType.equals(operations1, operations2);		
	}
	
	public static Condition merge(Condition condition1, Condition condition2)
	{
		
		/*
		 * <ConditionType> 	 	 	 	
		operation 	<OperationListType> 	Yes
		any 	namespace="##other" 	 ?
		DisplayElementGroup 		DisplayElementGroup 	Merge
		Alternative 		<AlternativeConditionalType> 	Merge
		ResourceConstraint 		<ConditionalResourceConstraintType> 	Merge 
		 */
		
		//TODO:		
		//condition1.setAlternativeConditions(AlternativeConditionType.merge(condition1.getAlternativeConditions(),condition2.getAlternativeConditions()));		
		//condition1.setConditionalResourceConstraints(ConditionalResourceConstraintType.merge(condition1.getConditionalResourceConstraints(),condition2.getConditionalResourceConstraints()));
		condition1.setDescription(TranslatableStringType.merge(condition1.getDescription(), condition2.getDescription()));
		condition1.setDisplayName(TranslatableStringType.merge(condition1.getDisplayName(), condition2.getDisplayName()));
		condition1.setShortDescription(TranslatableStringType.merge(condition1.getShortDescription(), condition2.getShortDescription()));
		
		return condition1;		
	}
}
