/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.MaintenanceInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ManufacturerInformation;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.TranslatableString;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;



public class ManufacturerInformationType {
	
	public static ManufacturerInformation merge(ManufacturerInformation info1, ManufacturerInformation info2)
	{
		/*<ManufacturerType> 	 	 	 	
	Name 		<DisplayTextType> 	Yes
	Location 		<LocationType> 	Merge
	ContactInformation 		<DisplayTextType> 	Merge
	any 		namespace="##other" 	 ? */
		
		if (equals(info1,info2))
		{
			return info1;
		}
		else return null;
	
	}
	
	public static boolean equals(ManufacturerInformation info1, ManufacturerInformation info2)
	{
		return TranslatableStringType.equals(info1.getName(),info2.getName());				
	}
	
}
