/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.Properties;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageIdentity;

public class PackageIdentityType {
	
	public static PackageIdentity merge (   PackageIdentity packageIdentity1, PackageIdentity packageIdentity2){
		/*
		<PackageIdentityType> 	 	 	 Extension Of: <IdentityType> 	 Merge
		packageType 	<PackageTypeType> 	Merge
		contentType 	xsd:QName 	Merge
		label 	xsd:NCName 	Merge 
		*/
		
		packageIdentity1.setPackageTypes(PackageTypeType.merge(packageIdentity1.getPackageTypes(), packageIdentity2.getPackageTypes()));
		return packageIdentity1;
	}
}
