/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;

public class ResourceType {

	/*
	    <ResourceType>

		<xsd:complexType name="ResourceType">
		  <xsd:sequence>
		    <xsd:group ref="sdd-dd:DescriptionGroup" minOccurs="0"/>
		    <xsd:element name="Name" type="sdd-dd:VariableExpressionType" minOccurs="0" />
		    <xsd:element name="Property" type="sdd-dd:PropertyType" minOccurs="0" maxOccurs="unbounded"/>
		    <xsd:element name="HostedResource" type="sdd-dd:ResourceType" minOccurs="0" maxOccurs="unbounded"/>
		    <xsd:any namespace="##other" processContents="lax" minOccurs="0" maxOccurs="unbounded"/>
		  </xsd:sequence>
		  <xsd:attribute name="id" type="xsd:ID" use="required"/>
		  <xsd:attribute name="type" type="sdd-dd:ResourceTypeNameType" use="required"/>
		  <xsd:anyAttribute namespace="##other" processContents="lax"/>
		</xsd:complexType>
		
		Type 	Element 	Attribute 	Data Type 	Compare?
		<ResourceType> 				
				id 	xsd:ID 	Throw Away
				type 	<ResourceTypeNameType> 	Yes
				any 	namespace="##other" 	 ?
					DescriptionGroup 	Merge
			Name 		<VariableExpressionType> 	Yes
			Property 		<PropertyType> 	Yes
			HostedResource 		<ResourceType> 	Merge
			any 		namespace="##other" 	 ? 
	 */
	
	
	public static Collection <Resource> merge(Collection <Resource> resources1, Collection <Resource> resources2)
	{		
		Collection <Resource> resourcesToRemove = new ArrayList <Resource> ();
		Iterator <Resource> resourceIter1 = resources1.iterator();		
		//iterate through the resources
		while (resourceIter1.hasNext())
		{
			Resource resource1 = (Resource) resourceIter1.next();
			Iterator <Resource> resourceIter2 = resources2.iterator();
			while (resourceIter2.hasNext())
			{
				Resource resource2 = (Resource) resourceIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (resourcesToRemove.contains(resource2)==false)
				{
					if (equals(resource1, resource2))
					{  
						//merge hosted resources, types and description groups
						resourcesToRemove.add(resource2);						
						resource1.setHostedResources(merge(resource1.getHostedResources(),resource2.getHostedResources()));
						
					}
				}
					
			}
		}
		
		resources2.removeAll(resourcesToRemove);
		//remove all of the matches that were found
		
		Collection <Resource> finalResources = new ArrayList <Resource> ();
		//create and return a new collection with all of the remaining items
		finalResources.addAll(resources1);
		finalResources.addAll(resources2);		
		
		return finalResources;
		
	}	
	
	public static boolean equals(Resource resource1, Resource resource2)
	{	
		
		
		try
		{
			if (StringType.equals(resource1.getResourceType(), resource2.getResourceType())==false)
				return false;
		}
		catch (NullPointerException e)
		{
			System.out.println("Required parameter \"Type\" missing from resource");
			return false;
		}
		
		if ((resource1.getProperties()!=null)&&(resource2.getProperties()==null))
			return false;
		if ((resource1.getProperties()==null)&&(resource2.getProperties()!=null))
			return false;
		if ((resource1.getProperties()!=null)&&(resource2.getProperties()!=null))		
			if (PropertyType.equals(resource1.getProperties(), resource2.getProperties())==false)		
				return false;
		if ((resource1.getName()!=null)&&(resource2.getName()==null))
			return false;
		if ((resource1.getName()==null)&&(resource2.getName()!=null))
			return false;
		if ((resource1.getName()!=null)&&(resource2.getName()!=null))		
			if (StringType.equals(resource1.getName(), resource2.getName())==false)
				return false;
		
		return true;
	}
}


















