/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.FixIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.PackageIdentity;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.Resource;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.ResultingChangeMap;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.Relationship;

public class ResultingChangeMapType {
	
	public static Collection <ResultingChangeMap> merge (   Collection <ResultingChangeMap> resultingChangeMaps1, Collection <ResultingChangeMap> resultingChangeMaps2)
	{
		Collection <ResultingChangeMap> resultingChangeMapsToRemove = new ArrayList <ResultingChangeMap> ();
		Iterator <ResultingChangeMap> resultingChangeMapIter1 = resultingChangeMaps1.iterator();		
		//iterate through the resultingChangeMaps
		while (resultingChangeMapIter1.hasNext())
		{
			ResultingChangeMap resultingChangeMap1 = (ResultingChangeMap) resultingChangeMapIter1.next();
			Iterator <ResultingChangeMap> resultingChangeMapIter2 = resultingChangeMaps2.iterator();
			while (resultingChangeMapIter2.hasNext())
			{
				ResultingChangeMap resultingChangeMap2 = (ResultingChangeMap) resultingChangeMapIter2.next();
				//if you find a match that hasn't been found, note it
				//one of the equals needs to be deleted with its children merged over
				if (resultingChangeMapsToRemove.contains(resultingChangeMap2)==false)
				{
					if (equals(resultingChangeMap1, resultingChangeMap2))
					{  //merge hosted resultingChangeMaps, types and description groups
						resultingChangeMapsToRemove.add(resultingChangeMap2);						
						resultingChangeMap1 = merge(resultingChangeMap1,resultingChangeMap2);
						
					}
				}
					
			}
		}
		
		resultingChangeMaps2.removeAll(resultingChangeMapsToRemove);
		//remove all of the matches that were found
		
		Collection <ResultingChangeMap> finalResultingChangeMaps = new ArrayList <ResultingChangeMap> ();
		//create and return a new collection with all of the remaining items
		finalResultingChangeMaps.addAll(resultingChangeMaps1);
		finalResultingChangeMaps.addAll(resultingChangeMaps2);		
		
		return finalResultingChangeMaps;
		
	}

	public static ResultingChangeMap merge(ResultingChangeMap resultingChangeMap1, ResultingChangeMap resultingChangeMap2)
	{
		resultingChangeMap1.setName(StringType.merge(resultingChangeMap1.getName(), resultingChangeMap2.getName()));
		Properties myProps = resultingChangeMap1.getProperties();
		myProps.putAll(resultingChangeMap2.getProperties());
		resultingChangeMap1.setProperties(myProps);		
		resultingChangeMap1.setRelationships(RelationshipType.merge(resultingChangeMap1.getRelationships(), resultingChangeMap2.getRelationships()));
		return resultingChangeMap1;
	}

	private static boolean equals(ResultingChangeMap map1, ResultingChangeMap map2)
	{
		
		if ((map1.getCondition()!=null)&&(map2.getCondition()==null))
			return false;
		if ((map1.getCondition()==null)&&(map2.getCondition()!=null))
			return false;
		if ((map1.getCondition()!=null)&&(map2.getCondition()!=null))
		{
			if (ConditionType.equals(map1.getCondition(),map2.getCondition()))
				return true;
			else return false;
		}
		else return true;
			
		
	}
}
