/*******************************************************************************
 * Copyright (c) 2008 SAS Institute Inc.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     SAS Institute Inc. - initial API and implementation
 ******************************************************************************/
package org.eclipse.cosmos.me.provisional.deployment.sdd.tooling.btg.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.DeploymentDescriptor;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeInstallable;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.CompositeUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.InstallableUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.LocalizationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ConfigurationUnit;
import org.eclipse.cosmos.me.provisional.deployment.sdd.common.spi.contentunit.ResultingResource;



public class CompositeUnitType {
	
	public static CompositeUnit merge(CompositeUnit cu1, CompositeUnit cu2)
	{
		/*<CompositeUnitType> 	 	 	 	
		id 	xsd:ID 	Throw Away
		any 	namespace="##other" 	 ?
		Identity 		<IdentityType> 	Merge
		Condition 		<ConditionType> 	Merge
		Variables 		<VariablesType> 	Merge
		Requirements 		<RequirementsType> 	Merge
		ContentListGroup 		ContentListGroup 	Merge 
		*/
		
		cu1.setIdentityData(IdentityType.merge(cu1.getIdentityData(), cu2.getIdentityData()));
		cu1.setCondition(ConditionType.merge(cu1.getCondition(), cu2.getCondition()));
		cu1.setRequirements(RequirementType.merge(cu1.getRequirements(), cu2.getRequirements()));
		//merge variables by:
		//Parameters 	 	 <ParametersType> 	 Merge
		//ResourceProperty 		<ResourcePropertyType> 	Merge
		//DerivedVariable 		<DerivedVariableType> 	Merge
		
		Collection params = new ArrayList();
		params.add(ParameterGroupType.merge(cu1.getParameterGroups(), cu2.getParameterGroups()));
		//TODO may need to change this, keep for now.
		cu1.setParameterGroups(params);
		
		//merge contentlistgroup by:
		//InstallableUnit 	 	 <InstallableUnitType> 	 Merge
		//ConfigurationUnit 		<ConfigurationUnitType> 	Merge
		//CompositeUnit 		<CompositeUnitType> 	Merge
		//RequiredBase 		<RequiredBaseType> 	Merge
		//ContainedPackage 		<ReferencedPackageType> 	Merge
		
		cu1.setInstallableUnits(InstallableUnitType.merge(cu1.getInstallableUnits(), cu2.getInstallableUnits()));
		cu1.setCompositeUnits(CompositeUnitType.merge(cu1.getCompositeUnits(), cu2.getCompositeUnits()));
		//No required base in spi for compositeUnit
		//Note to self, SPI is terrible
		cu1.setContainedPackages(ReferencedPackageType.merge(cu1.getContainedPackages(),cu2.getContainedPackages()));
		
		
		return cu1;
	}
	
	public static Collection <CompositeUnit> merge(Collection <CompositeUnit> cus1, Collection <CompositeUnit> cus2)	
	{
		cus1.addAll(cus2);
		return cus1;
		
	}

	
}
